/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.database.type.MemoryAlignedDataType;
import org.locationtech.jts.geom.Coordinate;

public class LonLatDataType
extends MemoryAlignedDataType<Coordinate> {
    private static final double BITS = Math.pow(2.0, 31.0);
    private static final long SHIFT = 32L;
    private static final long MASK = 0xFFFFFFFFL;

    public LonLatDataType() {
        super(8);
    }

    public static long encodeLonLat(double lon, double lat) {
        long x = (long)((lon + 180.0) / 360.0 * BITS);
        long y = (long)((lat + 90.0) / 180.0 * BITS);
        long l = x << 32;
        long r = y & 0xFFFFFFFFL;
        return l | r;
    }

    public static double decodeLon(long value) {
        double l = value >>> 32;
        return l / BITS * 360.0 - 180.0;
    }

    public static double decodeLat(long value) {
        long r = value & 0xFFFFFFFFL;
        return (double)r / BITS * 180.0 - 90.0;
    }

    @Override
    public void write(ByteBuffer buffer, int position, Coordinate value) {
        buffer.putLong(position, LonLatDataType.encodeLonLat(value.x, value.y));
    }

    @Override
    public Coordinate read(ByteBuffer buffer, int position) {
        long value = buffer.getLong(position);
        return new Coordinate(LonLatDataType.decodeLon(value), LonLatDataType.decodeLat(value));
    }
}

