/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.postgres;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.List;
import javax.sql.DataSource;
import org.apache.baremaps.openstreetmap.model.Header;
import org.apache.baremaps.openstreetmap.repository.HeaderRepository;
import org.apache.baremaps.openstreetmap.repository.RepositoryException;
import org.apache.baremaps.postgres.copy.CopyWriter;
import org.postgresql.PGConnection;
import org.postgresql.copy.PGCopyOutputStream;

public class PostgresHeaderRepository
implements HeaderRepository {
    private final DataSource dataSource;
    private final String createTable;
    private final String dropTable;
    private final String truncateTable;
    private final String selectLatest;
    private final String select;
    private final String selectIn;
    private final String insert;
    private final String delete;
    private final String copy;

    public PostgresHeaderRepository(DataSource dataSource) {
        this(dataSource, "osm_headers", "replication_sequence_number", "replication_timestamp", "replication_url", "source", "writing_program");
    }

    public PostgresHeaderRepository(DataSource dataSource, String tableName, String replicationSequenceNumberColumn, String replicationTimestampColumn, String replicationUrlColumn, String sourceColumn, String writingProgramColumn) {
        this.dataSource = dataSource;
        this.createTable = String.format("CREATE TABLE IF NOT EXISTS %1$s (\n  %2$s bigint PRIMARY KEY,\n  %3$s timestamp without time zone,\n  %4$s text,\n  %5$s text,\n  %6$s text\n)", tableName, replicationSequenceNumberColumn, replicationTimestampColumn, replicationUrlColumn, sourceColumn, writingProgramColumn);
        this.dropTable = String.format("DROP TABLE IF EXISTS %1$s CASCADE", tableName);
        this.truncateTable = String.format("TRUNCATE TABLE %1$s", tableName);
        this.selectLatest = String.format("SELECT %2$s, %3$s, %4$s, %5$s, %6$s FROM %1$s ORDER BY %2$s DESC", tableName, replicationSequenceNumberColumn, replicationTimestampColumn, replicationUrlColumn, sourceColumn, writingProgramColumn);
        this.select = String.format("SELECT %2$s, %3$s, %4$s, %5$s, %6$s FROM %1$s WHERE %2$s = ?", tableName, replicationSequenceNumberColumn, replicationTimestampColumn, replicationUrlColumn, sourceColumn, writingProgramColumn);
        this.selectIn = String.format("SELECT %2$s, %3$s, %4$s, %5$s, %6$s FROM %1$s WHERE %2$s = ANY (?)", tableName, replicationSequenceNumberColumn, replicationTimestampColumn, replicationUrlColumn, sourceColumn, writingProgramColumn);
        this.insert = String.format("INSERT INTO %1$s (%2$s, %3$s, %4$s, %5$s, %6$s)\nVALUES (?, ?, ?, ?, ?)\nON CONFLICT (%2$s) DO UPDATE SET\n%3$s = excluded.%3$s,\n%4$s = excluded.%4$s,\n%5$s = excluded.%5$s,\n%6$s = excluded.%6$s", tableName, replicationSequenceNumberColumn, replicationTimestampColumn, replicationUrlColumn, sourceColumn, writingProgramColumn);
        this.delete = String.format("DELETE FROM %1$s WHERE %2$s = ?", tableName, replicationSequenceNumberColumn);
        this.copy = String.format("COPY %1$s (%2$s, %3$s, %4$s, %5$s, %6$s) FROM STDIN BINARY", tableName, replicationSequenceNumberColumn, replicationTimestampColumn, replicationUrlColumn, sourceColumn, writingProgramColumn);
    }

    @Override
    public void create() throws RepositoryException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.createTable);){
            statement.execute();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void drop() throws RepositoryException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.dropTable);){
            statement.execute();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void truncate() throws RepositoryException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.truncateTable);){
            statement.execute();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Header> selectAll() throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Header selectLatest() throws RepositoryException {
        return this.selectAll().get(0);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Header get(Long key) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Header> get(List<Long> keys) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void put(Header value) throws RepositoryException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.insert);){
            this.setValue(statement, value);
            statement.execute();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void put(List<Header> values) throws RepositoryException {
        if (values.isEmpty()) {
            return;
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.insert);){
            for (Header value : values) {
                statement.clearParameters();
                this.setValue(statement, value);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void delete(Long key) throws RepositoryException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.delete);){
            statement.setObject(1, key);
            statement.execute();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void delete(List<Long> keys) throws RepositoryException {
        if (keys.isEmpty()) {
            return;
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.delete);){
            for (Long key : keys) {
                statement.clearParameters();
                statement.setObject(1, key);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void copy(List<Header> values) throws RepositoryException {
        if (values.isEmpty()) {
            return;
        }
        try (Connection connection = this.dataSource.getConnection();){
            PGConnection pgConnection = connection.unwrap(PGConnection.class);
            try (CopyWriter writer = new CopyWriter(new PGCopyOutputStream(pgConnection, this.copy));){
                writer.writeHeader();
                for (Header value : values) {
                    writer.startRow(5);
                    writer.writeLong(value.getReplicationSequenceNumber());
                    writer.writeLocalDateTime(value.getReplicationTimestamp());
                    writer.write(value.getReplicationUrl());
                    writer.write(value.getSource());
                    writer.write(value.getWritingProgram());
                }
            }
        }
        catch (IOException | SQLException e) {
            throw new RepositoryException(e);
        }
    }

    private Header getValue(ResultSet resultSet) throws SQLException {
        long replicationSequenceNumber = resultSet.getLong(1);
        LocalDateTime replicationTimestamp = resultSet.getObject(2, LocalDateTime.class);
        String replicationUrl = resultSet.getString(3);
        String source = resultSet.getString(4);
        String writingProgram = resultSet.getString(5);
        return new Header(replicationSequenceNumber, replicationTimestamp, replicationUrl, source, writingProgram);
    }

    private void setValue(PreparedStatement statement, Header value) throws SQLException {
        statement.setObject(1, value.getReplicationSequenceNumber());
        statement.setObject(2, value.getReplicationTimestamp());
        statement.setObject(3, value.getReplicationUrl());
        statement.setObject(4, value.getSource());
        statement.setObject(5, value.getWritingProgram());
    }
}

