/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.serializer.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.utils.AbstractStringSerializer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StringSerializer
extends AbstractStringSerializer {
    private static final SerializerDeserializer<String> UTF_8_SERIALIZER = new AbstractStringSerializer(StandardCharsets.UTF_8){

        @Override
        public void serialize(String toSerialize, BufferAllocator allocator, Buffer buffer) {
            buffer.writeUtf8((CharSequence)toSerialize);
        }
    };
    private static final SerializerDeserializer<String> US_ASCII_SERIALIZER = new AbstractStringSerializer(StandardCharsets.US_ASCII){

        @Override
        public void serialize(String toSerialize, BufferAllocator allocator, Buffer buffer) {
            buffer.writeAscii((CharSequence)toSerialize);
        }
    };

    private StringSerializer(Charset charset) {
        super(charset);
    }

    public static SerializerDeserializer<String> stringSerializer(Charset charset) {
        if (StandardCharsets.UTF_8.equals(charset)) {
            return UTF_8_SERIALIZER;
        }
        if (StandardCharsets.US_ASCII.equals(charset)) {
            return US_ASCII_SERIALIZER;
        }
        return new StringSerializer(charset);
    }
}

