/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.map;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.servicetalk.data.jackson.jersey.ServiceTalkJacksonSerializerFeature;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.sql.DataSource;
import javax.ws.rs.core.Application;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.server.ChangeResource;
import org.apache.baremaps.server.ClassPathResource;
import org.apache.baremaps.server.CorsFilter;
import org.apache.baremaps.server.StyleResource;
import org.apache.baremaps.server.TileResource;
import org.apache.baremaps.server.TilesetResource;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.postgres.PostgresTileStore;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.apache.baremaps.utils.PostgresUtils;
import org.apache.baremaps.vectortile.style.Style;
import org.apache.baremaps.vectortile.tileset.Tileset;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dev", description={"Start a development server with live reload."})
public class Dev
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Dev.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--cache"}, paramLabel="CACHE", description={"The caffeine cache directive."})
    private String cache = "";
    @CommandLine.Option(names={"--tileset"}, paramLabel="TILESET", description={"The tileset file."}, required=true)
    private Path tilesetPath;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"The style file."}, required=true)
    private Path stylePath;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        ConfigReader configReader = new ConfigReader();
        ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        Tileset tileset = (Tileset)objectMapper.readValue(configReader.read(this.tilesetPath), Tileset.class);
        DataSource datasource = PostgresUtils.createDataSourceFromObject((Object)tileset.getDatabase());
        TypeLiteral<Supplier<TileStore>> tileStoreType = new TypeLiteral<Supplier<TileStore>>(){};
        final Supplier<TileStore> tileStoreSupplier = () -> {
            try {
                Tileset tilesetObject = (Tileset)objectMapper.readValue(configReader.read(this.tilesetPath), Tileset.class);
                return new PostgresTileStore(datasource, tilesetObject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        TypeLiteral<Supplier<Style>> styleSupplierType = new TypeLiteral<Supplier<Style>>(){};
        Supplier<Style> styleSupplier = () -> {
            try {
                String config = configReader.read(this.stylePath);
                return (Style)objectMapper.readValue(config, Style.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        TypeLiteral<Supplier<Tileset>> tileJSONSupplierType = new TypeLiteral<Supplier<Tileset>>(){};
        Supplier<Tileset> tileJSONSupplier = () -> {
            try {
                String config = configReader.read(this.tilesetPath);
                return (Tileset)objectMapper.readValue(config, Tileset.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        ResourceConfig application = new ResourceConfig().register(CorsFilter.class).register(ChangeResource.class).register(TileResource.class).register(StyleResource.class).register(TilesetResource.class).register(ChangeResource.class).register(ClassPathResource.class).register((Object)ServiceTalkJacksonSerializerFeature.newContextResolver((ObjectMapper)objectMapper)).register((Object)new AbstractBinder(tileStoreType, styleSupplier, styleSupplierType, tileJSONSupplier, tileJSONSupplierType){
            final /* synthetic */ 1 val$tileStoreType;
            final /* synthetic */ Supplier val$styleSupplier;
            final /* synthetic */ 2 val$styleSupplierType;
            final /* synthetic */ Supplier val$tileJSONSupplier;
            final /* synthetic */ 3 val$tileJSONSupplierType;
            {
                this.val$tileStoreType = var3_3;
                this.val$styleSupplier = supplier2;
                this.val$styleSupplierType = var5_5;
                this.val$tileJSONSupplier = supplier3;
                this.val$tileJSONSupplierType = var7_7;
            }

            protected void configure() {
                this.bind("assets").to(String.class).named("directory");
                this.bind("viewer.html").to(String.class).named("index");
                this.bind(Dev.this.tilesetPath).to(Path.class).named("tileset");
                this.bind(Dev.this.stylePath).to(Path.class).named("style");
                this.bind(tileStoreSupplier).to((TypeLiteral)this.val$tileStoreType);
                this.bind(this.val$styleSupplier).to((TypeLiteral)this.val$styleSupplierType);
                this.bind(this.val$tileJSONSupplier).to((TypeLiteral)this.val$tileJSONSupplierType);
            }
        });
        BlockingStreamingHttpService httpService = new HttpJerseyRouterBuilder().buildBlockingStreaming((Application)application);
        HttpServerContext serverContext = HttpServers.forPort((int)this.port).listenBlockingStreamingAndAwait(httpService);
        logger.info("Listening on {}", (Object)serverContext.listenAddress());
        serverContext.awaitShutdown();
        return 0;
    }
}

