/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api.internal;

import io.servicetalk.client.api.ClientGroup;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.client.api.partition.PartitionAttributes;
import io.servicetalk.client.api.partition.PartitionMap;
import io.servicetalk.client.api.partition.PartitionMapFactory;
import io.servicetalk.client.api.partition.PartitionedServiceDiscovererEvent;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.GroupedPublisher;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class DefaultPartitionedClientGroup<U, R, Client extends ListenableAsyncCloseable>
implements ClientGroup<PartitionAttributes, Client> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPartitionedClientGroup.class);
    private final PartitionMap<Partition<Client>> partitionMap;
    private final SequentialCancellable sequentialCancellable = new SequentialCancellable();
    private final Function<PartitionAttributes, Client> unknownPartitionClient;

    public DefaultPartitionedClientGroup(Function<PartitionAttributes, Client> closedPartitionClient, Function<PartitionAttributes, Client> unknownPartitionClient, PartitionedClientFactory<U, R, Client> clientFactory, PartitionMapFactory partitionMapFactory, Publisher<PartitionedServiceDiscovererEvent<R>> psdEvents, int psdMaxQueueSize) {
        this.unknownPartitionClient = unknownPartitionClient;
        this.partitionMap = partitionMapFactory.newPartitionMap(event -> new Partition<AsyncCloseable>((PartitionAttributes)event, (AsyncCloseable)closedPartitionClient.apply((PartitionAttributes)event)));
        SourceAdapters.toSource((Publisher)psdEvents.groupToMany(event -> ServiceDiscovererEvent.Status.UNAVAILABLE.equals((Object)event.status()) ? this.partitionMap.remove(event.partitionAddress()).iterator() : this.partitionMap.add(event.partitionAddress()).iterator(), psdMaxQueueSize)).subscribe((PublisherSource.Subscriber)new GroupedByPartitionSubscriber(clientFactory));
    }

    public Completable onClose() {
        return this.partitionMap.onClose();
    }

    public Completable onClosing() {
        return this.partitionMap.onClosing();
    }

    public Completable closeAsync() {
        return this.partitionMap.closeAsync().whenFinally(() -> ((SequentialCancellable)this.sequentialCancellable).cancel());
    }

    public Completable closeAsyncGracefully() {
        return this.partitionMap.closeAsyncGracefully().whenFinally(() -> ((SequentialCancellable)this.sequentialCancellable).cancel());
    }

    public Client get(PartitionAttributes partitionAttributes) {
        ListenableAsyncCloseable client;
        Partition partition = (Partition)this.partitionMap.get(partitionAttributes);
        if (partition == null || (client = (ListenableAsyncCloseable)partition.client()) == null) {
            return (Client)((ListenableAsyncCloseable)this.unknownPartitionClient.apply(partitionAttributes));
        }
        return (Client)client;
    }

    private final class GroupedByPartitionSubscriber
    implements PublisherSource.Subscriber<GroupedPublisher<Partition<Client>, ? extends PartitionedServiceDiscovererEvent<R>>> {
        private final PartitionedClientFactory<U, R, Client> clientFactory;

        GroupedByPartitionSubscriber(PartitionedClientFactory<U, R, Client> clientFactory) {
            this.clientFactory = clientFactory;
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            s.request(Long.MAX_VALUE);
            DefaultPartitionedClientGroup.this.sequentialCancellable.nextCancellable((Cancellable)s);
        }

        public void onNext(@Nonnull GroupedPublisher<Partition<Client>, ? extends PartitionedServiceDiscovererEvent<R>> newGroup) {
            Objects.requireNonNull(newGroup);
            ListenableAsyncCloseable newClient = (ListenableAsyncCloseable)Objects.requireNonNull(this.clientFactory.apply(((Partition)newGroup.key()).attributes, new PartitionServiceDiscoverer(newGroup)), "<null> Client created for partition");
            ((Partition)newGroup.key()).client(newClient);
        }

        public void onError(Throwable t) {
            LOGGER.info("Unexpected error in partitioned client group subscriber {}", (Object)this, (Object)t);
        }

        public void onComplete() {
            LOGGER.debug("partitioned client group subscriber {} terminated", (Object)this);
        }
    }

    private static final class Partition<C extends AsyncCloseable>
    implements AsyncCloseable {
        private static final AtomicReferenceFieldUpdater<Partition, Object> clientUpdater = AtomicReferenceFieldUpdater.newUpdater(Partition.class, Object.class, "client");
        private final PartitionAttributes attributes;
        private final C closed;
        @Nullable
        private volatile Object client;

        Partition(PartitionAttributes attributes, C closed) {
            this.attributes = Objects.requireNonNull(attributes, "PartitionAttributes for partition is null");
            this.closed = (AsyncCloseable)Objects.requireNonNull(closed, "Closed Client for partition is null");
        }

        void client(C client) {
            if (!clientUpdater.compareAndSet(this, null, client)) {
                client.closeAsync().subscribe();
            }
        }

        void closeNow() {
            this.closeAsync().subscribe();
        }

        @Nullable
        C client() {
            return (C)((AsyncCloseable)this.client);
        }

        public Completable closeAsync() {
            return new SubscribableCompletable(){

                protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                    AsyncCloseable oldClient = clientUpdater.getAndSet(this, closed);
                    if (oldClient != null && oldClient != closed) {
                        SourceAdapters.toSource((Completable)oldClient.closeAsync()).subscribe(subscriber);
                    } else {
                        SubscriberUtils.deliverCompleteFromSource((CompletableSource.Subscriber)subscriber);
                    }
                }
            };
        }

        public String toString() {
            return this.attributes.toString();
        }
    }

    private static final class PartitionServiceDiscoverer<U, R, C extends AsyncCloseable, PSDE extends PartitionedServiceDiscovererEvent<R>>
    implements ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> {
        private final ListenableAsyncCloseable close;
        private final GroupedPublisher<Partition<C>, PSDE> newGroup;
        private final Partition<C> partition;

        PartitionServiceDiscoverer(GroupedPublisher<Partition<C>, PSDE> newGroup) {
            this.newGroup = newGroup;
            this.partition = (Partition)newGroup.key();
            this.close = AsyncCloseables.emptyAsyncCloseable();
        }

        public Publisher<Collection<ServiceDiscovererEvent<R>>> discover(U ignoredAddress) {
            return this.newGroup.filter(new Predicate<PSDE>(){
                private final Map<R, MutableInt> addressCount = new HashMap();

                @Override
                public boolean test(PSDE evt) {
                    boolean acceptEvent;
                    if (ServiceDiscovererEvent.Status.EXPIRED.equals((Object)evt.status())) {
                        return false;
                    }
                    MutableInt counter = this.addressCount.computeIfAbsent(evt.address(), __ -> new MutableInt());
                    if (ServiceDiscovererEvent.Status.UNAVAILABLE.equals((Object)evt.status())) {
                        boolean bl = acceptEvent = --counter.value == 0;
                        if (acceptEvent) {
                            this.addressCount.remove(evt.address());
                            if (this.addressCount.isEmpty()) {
                                partition.closeNow();
                            }
                        }
                    } else {
                        acceptEvent = ++counter.value == 1;
                    }
                    return acceptEvent;
                }
            }).beforeFinally(this.partition::closeNow).map(Collections::singletonList);
        }

        public Completable onClose() {
            return this.close.onClose();
        }

        public Completable onClosing() {
            return this.close.onClosing();
        }

        public Completable closeAsync() {
            return this.close.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            return this.close.closeAsyncGracefully();
        }

        static final class MutableInt {
            int value;

            MutableInt() {
            }
        }
    }

    @Deprecated
    @FunctionalInterface
    public static interface PartitionedClientFactory<U, R, Client> {
        public Client apply(PartitionAttributes var1, ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> var2);
    }
}

