/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.incubator.channel.uring.IOUring;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NativeTransportUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeTransportUtils.class);
    private static final String REQUIRE_NATIVE_LIBS_NAME = "io.servicetalk.transport.netty.requireNativeLibs";
    private static final boolean REQUIRE_NATIVE_LIBS = Boolean.getBoolean("io.servicetalk.transport.netty.requireNativeLibs");
    private static final String NETTY_NO_NATIVE_NAME = "io.netty.transport.noNative";
    private static final boolean NETTY_NO_NATIVE = Boolean.getBoolean("io.netty.transport.noNative");
    private static final boolean IS_LINUX;
    private static final boolean IS_OSX_OR_BSD;
    private static final AtomicBoolean TRY_IO_URING;

    private NativeTransportUtils() {
    }

    private static void reactOnUnavailability(String transport, String os, Throwable cause) {
        if (REQUIRE_NATIVE_LIBS) {
            throw new IllegalStateException("Can not load required \"io.netty:netty-transport-native-" + transport + ":$nettyVersion:" + os + '-' + PlatformDependent.normalizedArch() + "\", it may impact responsiveness, reliability, and performance of the application. Fix the deployment to make sure the native libraries are packaged and can be loaded. Otherwise, unset \"-D" + REQUIRE_NATIVE_LIBS_NAME + "=true\" system property to let the application start without native libraries and set \"-D" + NETTY_NO_NATIVE_NAME + "=true\" if running without native libs is intentional. For more information, see https://netty.io/wiki/native-transports.html", cause);
        }
        if (NETTY_NO_NATIVE) {
            LOGGER.info("io.netty:netty-transport-native-{} is explicitly disabled with \"-D{}=true\". Note that it may impact responsiveness, reliability, and performance of the application. ServiceTalk recommends always running with native libraries. Consider using \"-D{}=true\" to fail application initialization without native libs. For more information, see https://netty.io/wiki/native-transports.html", new Object[]{transport, NETTY_NO_NATIVE_NAME, REQUIRE_NATIVE_LIBS_NAME});
        } else {
            LOGGER.warn("Can not load \"io.netty:netty-transport-native-{}:$nettyVersion:{}-{}\", it may impact responsiveness, reliability, and performance of the application. ServiceTalk recommends always running with native libraries. Consider using \"-D{}=true\" to fail application initialization without native libraries. If this is intentional, let netty know about it using \"-D{}=true\". For more information, see https://netty.io/wiki/native-transports.html", new Object[]{transport, os, PlatformDependent.normalizedArch(), REQUIRE_NATIVE_LIBS_NAME, NETTY_NO_NATIVE_NAME, cause});
        }
    }

    static boolean isIoUringAvailable() {
        return IS_LINUX && TRY_IO_URING.get() && IOUring.isAvailable();
    }

    static boolean isEpollAvailable() {
        return IS_LINUX && Epoll.isAvailable();
    }

    static boolean isKQueueAvailable() {
        return IS_OSX_OR_BSD && KQueue.isAvailable();
    }

    static boolean useIoUring(EventLoopGroup group) {
        if (!NativeTransportUtils.isIoUringAvailable()) {
            return false;
        }
        return group instanceof IOUringEventLoopGroup || group instanceof EventLoop && ((EventLoop)group).parent() instanceof IOUringEventLoopGroup;
    }

    static boolean useEpoll(EventLoopGroup group) {
        if (!NativeTransportUtils.isEpollAvailable()) {
            return false;
        }
        return group instanceof EpollEventLoopGroup || group instanceof EventLoop && ((EventLoop)group).parent() instanceof EpollEventLoopGroup;
    }

    static boolean useKQueue(EventLoopGroup group) {
        if (!NativeTransportUtils.isKQueueAvailable()) {
            return false;
        }
        return group instanceof KQueueEventLoopGroup || group instanceof EventLoop && ((EventLoop)group).parent() instanceof KQueueEventLoopGroup;
    }

    static boolean isUnixDomainSocketSupported(EventLoopGroup group) {
        return NativeTransportUtils.useEpoll(group) || NativeTransportUtils.useKQueue(group);
    }

    static boolean isFileDescriptorSocketAddressSupported(EventLoopGroup group) {
        return NativeTransportUtils.useEpoll(group) || NativeTransportUtils.useKQueue(group);
    }

    static void tryIoUring(boolean tryIoUring) {
        TRY_IO_URING.set(tryIoUring);
    }

    static {
        String os = PlatformDependent.normalizedOs();
        IS_LINUX = "linux".equals(os);
        IS_OSX_OR_BSD = "osx".equals(os) || os.contains("bsd");
        TRY_IO_URING = new AtomicBoolean(Boolean.getBoolean("io.servicetalk.transport.netty.tryIoUring"));
        if (IS_LINUX && !Epoll.isAvailable()) {
            NativeTransportUtils.reactOnUnavailability("epoll", os, Epoll.unavailabilityCause());
        } else if (IS_OSX_OR_BSD && !KQueue.isAvailable()) {
            NativeTransportUtils.reactOnUnavailability("kqueue", "osx", KQueue.unavailabilityCause());
        }
    }
}

