/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpStreamingSerializerDeserializer;
import io.servicetalk.oio.api.PayloadWriter;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class DefaultHttpStreamingSerializerDeserializer<T>
implements HttpStreamingSerializerDeserializer<T> {
    private final StreamingSerializerDeserializer<T> serializer;
    private final Consumer<HttpHeaders> headersSerializeConsumer;
    private final Predicate<HttpHeaders> headersDeserializePredicate;

    DefaultHttpStreamingSerializerDeserializer(StreamingSerializerDeserializer<T> serializer, Consumer<HttpHeaders> headersSerializeConsumer, Predicate<HttpHeaders> headersDeserializePredicate) {
        this.serializer = Objects.requireNonNull(serializer);
        this.headersSerializeConsumer = Objects.requireNonNull(headersSerializeConsumer);
        this.headersDeserializePredicate = Objects.requireNonNull(headersDeserializePredicate);
    }

    @Override
    public BlockingIterable<Buffer> serialize(HttpHeaders headers, BlockingIterable<T> value, BufferAllocator allocator) {
        this.headersSerializeConsumer.accept(headers);
        return this.serializer.serialize(value, allocator);
    }

    @Override
    public Publisher<Buffer> serialize(HttpHeaders headers, Publisher<T> value, BufferAllocator allocator) {
        this.headersSerializeConsumer.accept(headers);
        return this.serializer.serialize(value, allocator);
    }

    @Override
    public HttpPayloadWriter<T> serialize(HttpHeaders headers, final HttpPayloadWriter<Buffer> payloadWriter, BufferAllocator allocator) {
        this.headersSerializeConsumer.accept(headers);
        final PayloadWriter result = this.serializer.serialize(payloadWriter, allocator);
        return new HttpPayloadWriter<T>(){

            @Override
            public HttpHeaders trailers() {
                return payloadWriter.trailers();
            }

            public void write(T t) throws IOException {
                result.write(t);
            }

            public void close(Throwable cause) throws IOException {
                result.close(cause);
            }

            public void close() throws IOException {
                result.close();
            }

            public void flush() throws IOException {
                result.flush();
            }
        };
    }

    @Override
    public BlockingIterable<T> deserialize(HttpHeaders headers, BlockingIterable<Buffer> payload, BufferAllocator allocator) {
        HeaderUtils.deserializeCheckContentType(headers, this.headersDeserializePredicate);
        return this.serializer.deserialize(payload, allocator);
    }

    @Override
    public Publisher<T> deserialize(HttpHeaders headers, Publisher<Buffer> payload, BufferAllocator allocator) {
        HeaderUtils.deserializeCheckContentType(headers, this.headersDeserializePredicate);
        return this.serializer.deserialize(payload, allocator);
    }
}

