/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class HttpStringDeserializer
implements HttpDeserializer<String> {
    static final HttpStringDeserializer UTF_8_STRING_DESERIALIZER = new HttpStringDeserializer(StandardCharsets.UTF_8, headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.TEXT_PLAIN, StandardCharsets.UTF_8));
    private final Charset charset;
    private final Predicate<HttpHeaders> checkContentType;

    HttpStringDeserializer(Charset charset, Predicate<HttpHeaders> checkContentType) {
        this.charset = charset;
        this.checkContentType = checkContentType;
    }

    @Override
    public String deserialize(HttpHeaders headers, Buffer payload) {
        HeaderUtils.checkContentType(headers, this.checkContentType);
        return payload.toString(this.charset);
    }

    @Override
    public BlockingIterable<String> deserialize(HttpHeaders headers, BlockingIterable<Buffer> payload) {
        HeaderUtils.checkContentType(headers, this.checkContentType);
        return () -> {
            final BlockingIterator iterator = payload.iterator();
            return new BlockingIterator<String>(){

                public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                    return iterator.hasNext(timeout, unit);
                }

                public String next(long timeout, TimeUnit unit) throws TimeoutException {
                    return HttpStringDeserializer.this.toString((Buffer)iterator.next(timeout, unit));
                }

                public void close() throws Exception {
                    iterator.close();
                }

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public String next() {
                    return HttpStringDeserializer.this.toString((Buffer)iterator.next());
                }
            };
        };
    }

    @Override
    public Publisher<String> deserialize(HttpHeaders headers, Publisher<Buffer> payload) {
        HeaderUtils.checkContentType(headers, this.checkContentType);
        return payload.map(this::toString);
    }

    @Nullable
    private String toString(@Nullable Buffer buffer) {
        return buffer == null ? null : buffer.toString(this.charset);
    }
}

