/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ContextMapUtils {
    private ContextMapUtils() {
    }

    public static String toString(ContextMap map) {
        String simpleName = map.getClass().getSimpleName();
        int size = map.size();
        if (size == 0) {
            return simpleName + '@' + Integer.toHexString(System.identityHashCode(map)) + ":{}";
        }
        StringBuilder sb = new StringBuilder(simpleName.length() + 12 + size * 90);
        sb.append(simpleName).append('@').append(Integer.toHexString(System.identityHashCode(map))).append(":{");
        map.forEach((key, value) -> {
            sb.append(key).append('=').append(value == map ? "(this Map)" : value).append(',').append(' ');
            return true;
        });
        sb.setLength(sb.length() - 2);
        return sb.append('}').toString();
    }

    public static boolean equals(ContextMap first, ContextMap second) {
        if (first.size() != second.size()) {
            return false;
        }
        ContextMap.Key stopped = first.forEach((key, value) -> second.contains(key, value));
        return stopped == null;
    }

    public static void ensureType(ContextMap.Key<?> key, @Nullable Object value) {
        Objects.requireNonNull(key);
        if (value != null && !key.type().isInstance(value)) {
            throw new IllegalArgumentException("Type of the value " + value + '(' + value.getClass() + ')' + " does mot match with " + key);
        }
    }
}

