/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import java.util.function.Function;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.OperandHandlers;
import org.apache.calcite.sql.type.SqlOperandHandler;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlBasicFunction
extends SqlFunction {
    private final SqlSyntax syntax;
    private final boolean deterministic;
    private final SqlOperandHandler operandHandler;
    private final Function<SqlOperatorBinding, SqlMonotonicity> monotonicityInference;

    private SqlBasicFunction(String name, SqlKind kind, SqlSyntax syntax, boolean deterministic, SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, SqlOperandHandler operandHandler, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category, Function<SqlOperatorBinding, SqlMonotonicity> monotonicityInference) {
        super(name, kind, Objects.requireNonNull(returnTypeInference, "returnTypeInference"), operandTypeInference, Objects.requireNonNull(operandTypeChecker, "operandTypeChecker"), category);
        this.syntax = Objects.requireNonNull(syntax, "syntax");
        this.deterministic = deterministic;
        this.operandHandler = Objects.requireNonNull(operandHandler, "operandHandler");
        this.monotonicityInference = Objects.requireNonNull(monotonicityInference, "monotonicityInference");
    }

    public static SqlBasicFunction create(SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        return new SqlBasicFunction(kind.name(), kind, SqlSyntax.FUNCTION, true, returnTypeInference, null, OperandHandlers.DEFAULT, operandTypeChecker, SqlFunctionCategory.SYSTEM, call -> SqlMonotonicity.NOT_MONOTONIC);
    }

    public static SqlBasicFunction create(String name, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        return new SqlBasicFunction(name, SqlKind.OTHER_FUNCTION, SqlSyntax.FUNCTION, true, returnTypeInference, null, OperandHandlers.DEFAULT, operandTypeChecker, SqlFunctionCategory.NUMERIC, call -> SqlMonotonicity.NOT_MONOTONIC);
    }

    public static SqlBasicFunction create(String name, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        return new SqlBasicFunction(name, SqlKind.OTHER_FUNCTION, SqlSyntax.FUNCTION, true, returnTypeInference, null, OperandHandlers.DEFAULT, operandTypeChecker, category, call -> SqlMonotonicity.NOT_MONOTONIC);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return Objects.requireNonNull(super.getReturnTypeInference(), "returnTypeInference");
    }

    @Override
    public SqlOperandTypeChecker getOperandTypeChecker() {
        return Objects.requireNonNull(super.getOperandTypeChecker(), "operandTypeChecker");
    }

    @Override
    public SqlSyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return this.monotonicityInference.apply(call);
    }

    @Override
    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        return this.operandHandler.rewriteCall(validator, call);
    }

    public SqlBasicFunction withName(String name) {
        return new SqlBasicFunction(name, this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.getFunctionType(), this.monotonicityInference);
    }

    public SqlBasicFunction withKind(SqlKind kind) {
        return new SqlBasicFunction(this.getName(), kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.getFunctionType(), this.monotonicityInference);
    }

    public SqlBasicFunction withFunctionType(SqlFunctionCategory category) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), category, this.monotonicityInference);
    }

    public SqlBasicFunction withSyntax(SqlSyntax syntax) {
        return new SqlBasicFunction(this.getName(), this.kind, syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.getFunctionType(), this.monotonicityInference);
    }

    public SqlBasicFunction withOperandTypeInference(SqlOperandTypeInference operandTypeInference) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), operandTypeInference, this.operandHandler, this.getOperandTypeChecker(), this.getFunctionType(), this.monotonicityInference);
    }

    public SqlBasicFunction withOperandHandler(SqlOperandHandler operandHandler) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), operandHandler, this.getOperandTypeChecker(), this.getFunctionType(), this.monotonicityInference);
    }

    public SqlBasicFunction withDeterministic(boolean deterministic) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.getFunctionType(), this.monotonicityInference);
    }

    public SqlBasicFunction withMonotonicityInference(Function<SqlOperatorBinding, SqlMonotonicity> monotonicityInference) {
        return new SqlBasicFunction(this.getName(), this.kind, this.syntax, this.deterministic, this.getReturnTypeInference(), this.getOperandTypeInference(), this.operandHandler, this.getOperandTypeChecker(), this.getFunctionType(), monotonicityInference);
    }
}

