/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlTimestampAddFunction
extends SqlFunction {
    private static final int MILLISECOND_PRECISION = 3;
    private static final int MICROSECOND_PRECISION = 6;
    private static final SqlReturnTypeInference RETURN_TYPE_INFERENCE = opBinding -> SqlTimestampAddFunction.deduceType(opBinding.getTypeFactory(), opBinding.getOperandLiteralValue(0, TimeUnit.class), opBinding.getOperandType(2));

    @Deprecated
    public static RelDataType deduceType(RelDataTypeFactory typeFactory, @Nullable TimeUnit timeUnit, RelDataType operandType1, RelDataType operandType2) {
        RelDataType type = SqlTimestampAddFunction.deduceType(typeFactory, timeUnit, operandType2);
        return typeFactory.createTypeWithNullability(type, operandType1.isNullable() || operandType2.isNullable());
    }

    static RelDataType deduceType(RelDataTypeFactory typeFactory, @Nullable TimeUnit timeUnit, RelDataType datetimeType) {
        TimeUnit timeUnit2 = Util.first(timeUnit, TimeUnit.EPOCH);
        switch (timeUnit2) {
            case MILLISECOND: {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 3);
            }
            case MICROSECOND: {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 6);
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                SqlTypeName typeName = datetimeType.getSqlTypeName();
                switch (typeName) {
                    case TIME: 
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        break;
                    }
                    default: {
                        typeName = SqlTypeName.TIMESTAMP;
                    }
                }
                return typeFactory.createSqlType(typeName);
            }
        }
        return datetimeType;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        validator.validateTimeFrame((SqlIntervalQualifier)call.getOperandList().get(0));
    }

    SqlTimestampAddFunction(String name) {
        super(name, SqlKind.TIMESTAMP_ADD, RETURN_TYPE_INFERENCE.andThen(SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER, SqlTypeFamily.DATETIME), SqlFunctionCategory.TIMEDATE);
    }
}

