/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import javax.validation.constraints.Min;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.baremaps.ogcapi.model.Exception;
import org.apache.baremaps.ogcapi.model.TileSet;
import org.apache.baremaps.ogcapi.model.TileSets;

@Path(value="/tiles")
@Api(description="the tiles API")
public interface TilesApi {
    @GET
    @Path(value="/{tileSetId}/{tileMatrix}/{tileRow}/{tileCol}")
    @Produces(value={"application/vnd.mapbox-vector-tile", "application/json"})
    @ApiOperation(value="Retrieve a vector tile including one or more collections from the dataset.", notes="", tags={"Vector Tiles"})
    @ApiResponses(value={@ApiResponse(code=200, message="A vector tile returned as a response.", response=File.class), @ApiResponse(code=204, message="No data available for this tile.", response=Void.class), @ApiResponse(code=404, message="The requested resource does not exist on the server. For example, a path parameter had an incorrect value.", response=Exception.class), @ApiResponse(code=500, message="A server error occurred.", response=Exception.class)})
    public Response getTile(@PathParam(value="tileSetId") @ApiParam(value="Identifier for a supported TileMatrixSet") String var1, @PathParam(value="tileMatrix") @ApiParam(value="Identifier selecting one of the scales defined in the TileMatrixSet and representing the scaleDenominator the tile. For example, Ireland is fully within the Tile at WebMercatorQuad tileMatrix&#x3D;5, tileRow&#x3D;10 and tileCol&#x3D;15.") String var2, @PathParam(value="tileRow") @Min(value=0L) @ApiParam(value="Row index of the tile on the selected TileMatrix. It cannot exceed the MatrixWidth-1 for the selected TileMatrix. For example, Ireland is fully within the Tile at WebMercatorQuad tileMatrix&#x3D;5, tileRow&#x3D;10 and tileCol&#x3D;15.") @Min(value=0L) Integer var3, @PathParam(value="tileCol") @Min(value=0L) @ApiParam(value="Column index of the tile on the selected TileMatrix. It cannot exceed the MatrixHeight-1 for the selected TileMatrix. For example, Ireland is fully within the Tile at WebMercatorQuad tileMatrix&#x3D;5, tileRow&#x3D;10 and tileCol&#x3D;15.") @Min(value=0L) Integer var4);

    @GET
    @Path(value="/{tileSetId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the vector tileSet metadata for the whole dataset and the specified tiling scheme (tile matrix set)", notes="", tags={"Vector Tiles"})
    @ApiResponses(value={@ApiResponse(code=200, message="Description of the tileSet", response=TileSet.class), @ApiResponse(code=404, message="The requested resource does not exist on the server. For example, a path parameter had an incorrect value.", response=Exception.class), @ApiResponse(code=500, message="A server error occurred.", response=Exception.class)})
    public Response getTileSet(@PathParam(value="tileSetId") @ApiParam(value="Identifier for a supported TileMatrixSet") String var1);

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a list of available vector tileSets for the dataset", notes="", tags={"Vector Tiles"})
    @ApiResponses(value={@ApiResponse(code=200, message="List of available tileSets.", response=TileSets.class), @ApiResponse(code=404, message="The requested resource does not exist on the server. For example, a path parameter had an incorrect value.", response=Exception.class), @ApiResponse(code=500, message="A server error occurred.", response=Exception.class)})
    public Response getTileSets();
}

