/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.ogcapi.model.Collection;
import org.apache.baremaps.ogcapi.model.Link;

@JsonTypeName(value="collections")
public class Collections {
    @Valid
    private List<Link> links = new ArrayList<Link>();
    @Valid
    private Date timeStamp;
    @Valid
    private Integer numberMatched;
    @Valid
    private Integer numberReturned;
    @Valid
    private List<Collection> collections = new ArrayList<Collection>();

    public Collections links(List<Link> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="links")
    @NotNull
    public List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public Collections addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    public Collections removeLinksItem(Link linksItem) {
        if (linksItem != null && this.links != null) {
            this.links.remove(linksItem);
        }
        return this;
    }

    public Collections timeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="timeStamp")
    public Date getTimeStamp() {
        return this.timeStamp;
    }

    @JsonProperty(value="timeStamp")
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Collections numberMatched(Integer numberMatched) {
        this.numberMatched = numberMatched;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="numberMatched")
    @Min(value=0L)
    public @Min(value=0L) Integer getNumberMatched() {
        return this.numberMatched;
    }

    @JsonProperty(value="numberMatched")
    public void setNumberMatched(Integer numberMatched) {
        this.numberMatched = numberMatched;
    }

    public Collections numberReturned(Integer numberReturned) {
        this.numberReturned = numberReturned;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="numberReturned")
    @Min(value=0L)
    public @Min(value=0L) Integer getNumberReturned() {
        return this.numberReturned;
    }

    @JsonProperty(value="numberReturned")
    public void setNumberReturned(Integer numberReturned) {
        this.numberReturned = numberReturned;
    }

    public Collections collections(List<Collection> collections) {
        this.collections = collections;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="collections")
    @NotNull
    public List<Collection> getCollections() {
        return this.collections;
    }

    @JsonProperty(value="collections")
    public void setCollections(List<Collection> collections) {
        this.collections = collections;
    }

    public Collections addCollectionsItem(Collection collectionsItem) {
        if (this.collections == null) {
            this.collections = new ArrayList<Collection>();
        }
        this.collections.add(collectionsItem);
        return this;
    }

    public Collections removeCollectionsItem(Collection collectionsItem) {
        if (collectionsItem != null && this.collections != null) {
            this.collections.remove(collectionsItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collections collections = (Collections)o;
        return Objects.equals(this.links, collections.links) && Objects.equals(this.timeStamp, collections.timeStamp) && Objects.equals(this.numberMatched, collections.numberMatched) && Objects.equals(this.numberReturned, collections.numberReturned) && Objects.equals(this.collections, collections.collections);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.timeStamp, this.numberMatched, this.numberReturned, this.collections);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Collections {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    timeStamp: ").append(this.toIndentedString(this.timeStamp)).append("\n");
        sb.append("    numberMatched: ").append(this.toIndentedString(this.numberMatched)).append("\n");
        sb.append("    numberReturned: ").append(this.toIndentedString(this.numberReturned)).append("\n");
        sb.append("    collections: ").append(this.toIndentedString(this.collections)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

