/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.ExtentSpatialGridInner;

@ApiModel(description="The spatial extent of the data in the collection.")
@JsonTypeName(value="extent_spatial")
public class ExtentSpatial {
    @Valid
    private List<List<BigDecimal>> bbox = null;
    @Valid
    private CrsEnum crs = CrsEnum._1_3_CRS84;
    @Valid
    private List<ExtentSpatialGridInner> grid = null;

    public ExtentSpatial bbox(List<List<BigDecimal>> bbox) {
        this.bbox = bbox;
        return this;
    }

    @ApiModelProperty(value="One or more bounding boxes that describe the spatial extent of the dataset. In the Core only a single bounding box is supported.  Extensions may support additional areas. The first bounding box describes the overall spatial extent of the data. All subsequent bounding boxes describe more precise bounding boxes, e.g., to identify clusters of data. Clients only interested in the overall spatial extent will only need to access the first item in each array.")
    @JsonProperty(value="bbox")
    @Size(min=1)
    public @Size(min=1) List<List<BigDecimal>> getBbox() {
        return this.bbox;
    }

    @JsonProperty(value="bbox")
    public void setBbox(List<List<BigDecimal>> bbox) {
        this.bbox = bbox;
    }

    public ExtentSpatial addBboxItem(List<BigDecimal> bboxItem) {
        if (this.bbox == null) {
            this.bbox = new ArrayList<List<BigDecimal>>();
        }
        this.bbox.add(bboxItem);
        return this;
    }

    public ExtentSpatial removeBboxItem(List<BigDecimal> bboxItem) {
        if (bboxItem != null && this.bbox != null) {
            this.bbox.remove(bboxItem);
        }
        return this;
    }

    public ExtentSpatial crs(CrsEnum crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(value="Coordinate reference system of the coordinates in the spatial extent (property `bbox`). The default reference system is WGS 84 longitude/latitude. In the Core the only other supported coordinate reference system is WGS 84 longitude/latitude/ellipsoidal height for coordinates with height. Extensions may support additional coordinate reference systems and add additional enum values.")
    @JsonProperty(value="crs")
    public CrsEnum getCrs() {
        return this.crs;
    }

    @JsonProperty(value="crs")
    public void setCrs(CrsEnum crs) {
        this.crs = crs;
    }

    public ExtentSpatial grid(List<ExtentSpatialGridInner> grid) {
        this.grid = grid;
        return this;
    }

    @ApiModelProperty(value="Provides information about the limited availability of data within the collection organized as a grid (regular or irregular) along each spatial dimension.")
    @JsonProperty(value="grid")
    @Size(min=2, max=3)
    public @Size(min=2, max=3) List<ExtentSpatialGridInner> getGrid() {
        return this.grid;
    }

    @JsonProperty(value="grid")
    public void setGrid(List<ExtentSpatialGridInner> grid) {
        this.grid = grid;
    }

    public ExtentSpatial addGridItem(ExtentSpatialGridInner gridItem) {
        if (this.grid == null) {
            this.grid = new ArrayList<ExtentSpatialGridInner>();
        }
        this.grid.add(gridItem);
        return this;
    }

    public ExtentSpatial removeGridItem(ExtentSpatialGridInner gridItem) {
        if (gridItem != null && this.grid != null) {
            this.grid.remove(gridItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtentSpatial extentSpatial = (ExtentSpatial)o;
        return Objects.equals(this.bbox, extentSpatial.bbox) && Objects.equals((Object)this.crs, (Object)extentSpatial.crs) && Objects.equals(this.grid, extentSpatial.grid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bbox, this.crs, this.grid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtentSpatial {\n");
        sb.append("    bbox: ").append(this.toIndentedString(this.bbox)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString((Object)this.crs)).append("\n");
        sb.append("    grid: ").append(this.toIndentedString(this.grid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CrsEnum {
        _1_3_CRS84(String.valueOf("http://www.opengis.net/def/crs/OGC/1.3/CRS84")),
        _0_CRS84H(String.valueOf("http://www.opengis.net/def/crs/OGC/0/CRS84h"));

        private String value;

        private CrsEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static CrsEnum fromString(String s) {
            for (CrsEnum b : CrsEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static CrsEnum fromValue(String value) {
            for (CrsEnum b : CrsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

