/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.ogcapi.model.Link;
import org.apache.baremaps.ogcapi.model.TileSetCrs;

@ApiModel(description="A minimal tile matrix set element for use within a list of tile matrix sets linking to a full definition.")
@JsonTypeName(value="tileMatrixSet-item")
public class TileMatrixSetItem {
    @Valid
    private String id;
    @Valid
    private String title;
    @Valid
    private URI uri;
    @Valid
    private TileSetCrs crs;
    @Valid
    private List<Link> links = new ArrayList<Link>();

    public TileMatrixSetItem id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Optional local tile matrix set identifier, e.g. for use as unspecified `{tileSetId}` parameter. Implementation of 'identifier'")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public TileMatrixSetItem title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Title of this tile matrix set, normally used for display to a human")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public TileMatrixSetItem uri(URI uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(value="Reference to an official source for this tileMatrixSet")
    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    public void setUri(URI uri) {
        this.uri = uri;
    }

    public TileMatrixSetItem crs(TileSetCrs crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="crs")
    public TileSetCrs getCrs() {
        return this.crs;
    }

    @JsonProperty(value="crs")
    public void setCrs(TileSetCrs crs) {
        this.crs = crs;
    }

    public TileMatrixSetItem links(List<Link> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(required=true, value="Links to related resources. A 'self' link to the tile matrix set definition is required.")
    @JsonProperty(value="links")
    @NotNull
    public List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public TileMatrixSetItem addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    public TileMatrixSetItem removeLinksItem(Link linksItem) {
        if (linksItem != null && this.links != null) {
            this.links.remove(linksItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileMatrixSetItem tileMatrixSetItem = (TileMatrixSetItem)o;
        return Objects.equals(this.id, tileMatrixSetItem.id) && Objects.equals(this.title, tileMatrixSetItem.title) && Objects.equals(this.uri, tileMatrixSetItem.uri) && Objects.equals(this.crs, tileMatrixSetItem.crs) && Objects.equals(this.links, tileMatrixSetItem.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.uri, this.crs, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TileMatrixSetItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

