/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.client.api.NoAvailableHostException;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.netty.ExpectationFailedException;
import io.servicetalk.http.netty.LoadBalancerReadySubscriber;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategyInfluencer;
import io.servicetalk.transport.api.RetryableException;
import io.servicetalk.utils.internal.DurationUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public final class RetryingHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
ExecutionStrategyInfluencer<HttpExecutionStrategy> {
    private static final int DEFAULT_MAX_TOTAL_RETRIES = 4;
    private static final RetryingHttpRequesterFilter DISABLE_AUTO_RETRIES = new RetryingHttpRequesterFilter(true, false, false, 1, null, (__, ___) -> BackOffPolicy.NO_RETRIES);
    private static final RetryingHttpRequesterFilter DISABLE_ALL_RETRIES = new RetryingHttpRequesterFilter(false, true, false, 0, null, (__, ___) -> BackOffPolicy.NO_RETRIES);
    private final boolean waitForLb;
    private final boolean ignoreSdErrors;
    private final boolean mayReplayRequestPayload;
    private final int maxTotalRetries;
    @Nullable
    private final Function<HttpResponseMetaData, HttpResponseException> responseMapper;
    private final BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryFor;

    RetryingHttpRequesterFilter(boolean waitForLb, boolean ignoreSdErrors, boolean mayReplayRequestPayload, int maxTotalRetries, @Nullable Function<HttpResponseMetaData, HttpResponseException> responseMapper, BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryFor) {
        this.waitForLb = waitForLb;
        this.ignoreSdErrors = ignoreSdErrors;
        this.mayReplayRequestPayload = mayReplayRequestPayload;
        this.maxTotalRetries = maxTotalRetries;
        this.responseMapper = responseMapper;
        this.retryFor = retryFor;
    }

    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new ContextAwareRetryingHttpClientFilter(client);
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    public static RetryingHttpRequesterFilter disableAutoRetries() {
        return DISABLE_AUTO_RETRIES;
    }

    public static RetryingHttpRequesterFilter disableAllRetries() {
        return DISABLE_ALL_RETRIES;
    }

    private static UnaryOperator<Publisher<?>> messageBodyDuplicator() {
        return p -> p.map(item -> {
            if (item instanceof Buffer) {
                return ((Buffer)item).duplicate();
            }
            return item;
        });
    }

    public static final class Builder {
        private static final Function<HttpResponseMetaData, HttpResponseException> EXPECTATION_FAILED_MAPPER = metaData -> HttpResponseStatus.EXPECTATION_FAILED.equals((Object)metaData.status()) ? new ExpectationFailedException("Expectation failed", (HttpResponseMetaData)metaData) : null;
        private boolean waitForLb = true;
        private boolean ignoreSdErrors;
        private int maxTotalRetries = 4;
        private boolean retryExpectationFailed;
        private BiFunction<HttpRequestMetaData, RetryableException, BackOffPolicy> retryRetryableExceptions = (requestMetaData, e) -> BackOffPolicy.ofImmediateBounded();
        @Nullable
        private Function<HttpResponseMetaData, HttpResponseException> responseMapper;
        @Nullable
        private BiFunction<HttpRequestMetaData, IOException, BackOffPolicy> retryIdempotentRequests;
        @Nullable
        private BiFunction<HttpRequestMetaData, DelayedRetry, BackOffPolicy> retryDelayedRetries;
        @Nullable
        private BiFunction<HttpRequestMetaData, HttpResponseException, BackOffPolicy> retryResponses;
        @Nullable
        private BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryOther;

        public Builder waitForLoadBalancer(boolean waitForLb) {
            this.waitForLb = waitForLb;
            return this;
        }

        public Builder ignoreServiceDiscovererErrors(boolean ignoreSdErrors) {
            this.ignoreSdErrors = ignoreSdErrors;
            return this;
        }

        public Builder maxTotalRetries(int maxRetries) {
            if (maxRetries <= 0) {
                throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected: >0)");
            }
            this.maxTotalRetries = maxRetries;
            return this;
        }

        public Builder responseMapper(Function<HttpResponseMetaData, HttpResponseException> mapper) {
            this.responseMapper = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryRetryableExceptions(BiFunction<HttpRequestMetaData, RetryableException, BackOffPolicy> mapper) {
            this.retryRetryableExceptions = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryIdempotentRequests(BiFunction<HttpRequestMetaData, IOException, BackOffPolicy> mapper) {
            this.retryIdempotentRequests = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryExpectationFailed(boolean retryExpectationFailed) {
            this.retryExpectationFailed = retryExpectationFailed;
            return this;
        }

        public Builder retryDelayedRetries(BiFunction<HttpRequestMetaData, DelayedRetry, BackOffPolicy> mapper) {
            this.retryDelayedRetries = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryResponses(BiFunction<HttpRequestMetaData, HttpResponseException, BackOffPolicy> mapper) {
            this.retryResponses = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryOther(BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> mapper) {
            this.retryOther = Objects.requireNonNull(mapper);
            return this;
        }

        public RetryingHttpRequesterFilter build() {
            boolean retryExpectationFailed = this.retryExpectationFailed;
            Function<HttpResponseMetaData, HttpResponseException> thisResponseMapper = this.responseMapper;
            Function<HttpResponseMetaData, HttpResponseException> responseMapper = retryExpectationFailed ? (thisResponseMapper == null ? EXPECTATION_FAILED_MAPPER : metaData -> {
                HttpResponseException e = (HttpResponseException)thisResponseMapper.apply((HttpResponseMetaData)metaData);
                return e == null ? EXPECTATION_FAILED_MAPPER.apply((HttpResponseMetaData)metaData) : e;
            }) : thisResponseMapper;
            BiFunction<HttpRequestMetaData, RetryableException, BackOffPolicy> retryRetryableExceptions = this.retryRetryableExceptions;
            BiFunction<HttpRequestMetaData, IOException, BackOffPolicy> retryIdempotentRequests = this.retryIdempotentRequests;
            BiFunction<HttpRequestMetaData, DelayedRetry, BackOffPolicy> retryDelayedRetries = this.retryDelayedRetries;
            BiFunction<HttpRequestMetaData, HttpResponseException, BackOffPolicy> retryResponses = this.retryResponses;
            BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryOther = this.retryOther;
            boolean mayReplayRequestPayload = retryIdempotentRequests != null || retryDelayedRetries != null || retryResponses != null || retryOther != null;
            BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> allPredicate = (requestMetaData, throwable) -> {
                BackOffPolicy backOffPolicy;
                if (throwable instanceof RetryableException && (backOffPolicy = (BackOffPolicy)retryRetryableExceptions.apply((HttpRequestMetaData)requestMetaData, (RetryableException)throwable)) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (retryExpectationFailed && throwable instanceof ExpectationFailedException && requestMetaData.headers().containsIgnoreCase(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE)) {
                    requestMetaData.headers().remove(HttpHeaderNames.EXPECT);
                    return BackOffPolicy.ofImmediateBounded();
                }
                if (retryIdempotentRequests != null && throwable instanceof IOException && requestMetaData.method().properties().isIdempotent() && (backOffPolicy = (BackOffPolicy)retryIdempotentRequests.apply((HttpRequestMetaData)requestMetaData, (IOException)throwable)) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (retryDelayedRetries != null && throwable instanceof DelayedRetry && (backOffPolicy = (BackOffPolicy)retryDelayedRetries.apply((HttpRequestMetaData)requestMetaData, (DelayedRetry)((Object)throwable))) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (retryResponses != null && throwable instanceof HttpResponseException && (backOffPolicy = (BackOffPolicy)retryResponses.apply((HttpRequestMetaData)requestMetaData, (HttpResponseException)throwable)) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (retryOther != null) {
                    return (BackOffPolicy)retryOther.apply((HttpRequestMetaData)requestMetaData, (Throwable)throwable);
                }
                return BackOffPolicy.NO_RETRIES;
            };
            return new RetryingHttpRequesterFilter(this.waitForLb, this.ignoreSdErrors, mayReplayRequestPayload, this.maxTotalRetries, responseMapper, allPredicate);
        }
    }

    public static interface DelayedRetry {
        public Duration delay();
    }

    public static final class BackOffPolicy {
        private static final Duration FULL_JITTER = Duration.ofDays(1024L);
        private static final BackOffPolicy IMMEDIATE_DEFAULT_RETRIES = new BackOffPolicy(3);
        @Deprecated
        public static final BackOffPolicy NO_RETRIES = new BackOffPolicy(0);
        @Nullable
        final Duration initialDelay;
        @Nullable
        final Duration jitter;
        @Nullable
        final Duration maxDelay;
        @Nullable
        final Executor timerExecutor;
        final boolean exponential;
        final int maxRetries;

        BackOffPolicy(Duration initialDelay, Duration jitter, @Nullable Duration maxDelay, @Nullable Executor timerExecutor, boolean exponential, int maxRetries) {
            this.initialDelay = DurationUtils.ensurePositive((Duration)initialDelay, (String)"Initial delay should be a positive value.");
            this.jitter = DurationUtils.ensurePositive((Duration)jitter, (String)"jitter should be a positive value.");
            this.maxDelay = maxDelay != null ? DurationUtils.ensurePositive((Duration)maxDelay, (String)"Max delay (if provided), should be a positive value.") : null;
            this.timerExecutor = timerExecutor;
            this.exponential = exponential;
            if (maxRetries <= 0) {
                throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected > 0).");
            }
            this.maxRetries = maxRetries;
        }

        BackOffPolicy(int maxRetries) {
            this.initialDelay = null;
            this.jitter = null;
            this.maxDelay = null;
            this.timerExecutor = null;
            this.exponential = false;
            if (maxRetries < 0) {
                throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected >= 0).");
            }
            this.maxRetries = maxRetries;
        }

        @Deprecated
        public static BackOffPolicy ofImmediate() {
            return BackOffPolicy.ofImmediateBounded();
        }

        public static BackOffPolicy ofImmediateBounded() {
            return IMMEDIATE_DEFAULT_RETRIES;
        }

        public static BackOffPolicy ofImmediate(int maxRetries) {
            return new BackOffPolicy(maxRetries);
        }

        public static BackOffPolicy ofNoRetries() {
            return NO_RETRIES;
        }

        public static BackOffPolicy ofConstantBackoffFullJitter(Duration delay, int maxRetries) {
            return new BackOffPolicy(delay, FULL_JITTER, null, null, false, maxRetries);
        }

        public static BackOffPolicy ofConstantBackoffFullJitter(Duration delay, int maxRetries, Executor timerExecutor) {
            return new BackOffPolicy(delay, FULL_JITTER, null, timerExecutor, false, maxRetries);
        }

        public static BackOffPolicy ofConstantBackoffDeltaJitter(Duration delay, Duration jitter, int maxRetries) {
            return new BackOffPolicy(delay, jitter, null, null, false, maxRetries);
        }

        public static BackOffPolicy ofConstantBackoffDeltaJitter(Duration delay, Duration jitter, Executor timerExecutor, int maxRetries) {
            return new BackOffPolicy(delay, jitter, null, timerExecutor, false, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffFullJitter(Duration initialDelay, Duration maxDelay, int maxRetries) {
            return new BackOffPolicy(initialDelay, FULL_JITTER, maxDelay, null, true, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffFullJitter(Duration initialDelay, Duration maxDelay, int maxRetries, Executor timerExecutor) {
            return new BackOffPolicy(initialDelay, FULL_JITTER, maxDelay, timerExecutor, true, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffDeltaJitter(Duration initialDelay, Duration jitter, Duration maxDelay, int maxRetries) {
            return new BackOffPolicy(initialDelay, jitter, maxDelay, null, true, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffDeltaJitter(Duration initialDelay, Duration jitter, Duration maxDelay, int maxRetries, Executor timerExecutor) {
            return new BackOffPolicy(initialDelay, jitter, maxDelay, timerExecutor, true, maxRetries);
        }

        public BiIntFunction<Throwable, Completable> newStrategy(Executor alternativeTimerExecutor) {
            Executor effectiveExecutor;
            if (this.initialDelay == null) {
                return (count, throwable) -> count <= this.maxRetries ? Completable.completed() : Completable.failed((Throwable)throwable);
            }
            assert (this.jitter != null);
            Executor executor = effectiveExecutor = this.timerExecutor == null ? Objects.requireNonNull(alternativeTimerExecutor) : this.timerExecutor;
            if (this.exponential) {
                assert (this.maxDelay != null);
                return this.jitter == FULL_JITTER ? RetryStrategies.retryWithExponentialBackoffFullJitter((int)this.maxRetries, t -> true, (Duration)this.initialDelay, (Duration)this.maxDelay, (Executor)effectiveExecutor) : RetryStrategies.retryWithExponentialBackoffDeltaJitter((int)this.maxRetries, t -> true, (Duration)this.initialDelay, (Duration)this.jitter, (Duration)this.maxDelay, (Executor)effectiveExecutor);
            }
            return this.jitter == FULL_JITTER ? RetryStrategies.retryWithConstantBackoffFullJitter((int)this.maxRetries, t -> true, (Duration)this.initialDelay, (Executor)effectiveExecutor) : RetryStrategies.retryWithConstantBackoffDeltaJitter((int)this.maxRetries, t -> true, (Duration)this.initialDelay, (Duration)this.jitter, (Executor)effectiveExecutor);
        }
    }

    public static class HttpResponseException
    extends RuntimeException {
        private static final long serialVersionUID = -7182949760823647710L;
        @Deprecated
        public final HttpResponseMetaData metaData;
        @Deprecated
        public final String message;

        public HttpResponseException(String message, HttpResponseMetaData metaData) {
            super(message);
            this.metaData = Objects.requireNonNull(metaData);
            this.message = Objects.requireNonNull(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        public HttpResponseMetaData metaData() {
            return this.metaData;
        }

        @Override
        public String toString() {
            return super.toString() + ", metaData=" + this.metaData.toString(HeaderUtils.DEFAULT_HEADER_FILTER);
        }
    }

    final class ContextAwareRetryingHttpClientFilter
    extends StreamingHttpClientFilter {
        @Nullable
        private Completable sdStatus;
        @Nullable
        private AsyncCloseable closeAsync;
        @Nullable
        private LoadBalancerReadySubscriber loadBalancerReadySubscriber;

        private ContextAwareRetryingHttpClientFilter(FilterableStreamingHttpClient delegate) {
            super(delegate);
        }

        void inject(@Nullable Publisher<Object> lbEventStream, @Nullable Completable sdStatus) {
            assert (lbEventStream != null);
            assert (sdStatus != null);
            Completable completable = this.sdStatus = RetryingHttpRequesterFilter.this.ignoreSdErrors ? null : sdStatus;
            if (RetryingHttpRequesterFilter.this.waitForLb) {
                this.loadBalancerReadySubscriber = new LoadBalancerReadySubscriber();
                this.closeAsync = AsyncCloseables.toAsyncCloseable(__ -> {
                    this.loadBalancerReadySubscriber.cancel();
                    return Completable.completed();
                });
                SourceAdapters.toSource(lbEventStream).subscribe((PublisherSource.Subscriber)this.loadBalancerReadySubscriber);
            } else {
                this.loadBalancerReadySubscriber = null;
                this.closeAsync = AsyncCloseables.emptyAsyncCloseable();
            }
        }

        BiIntFunction<Throwable, Completable> retryStrategy(HttpRequestMetaData requestMetaData, ExecutionContext<HttpExecutionStrategy> context) {
            HttpExecutionStrategy strategy = (HttpExecutionStrategy)requestMetaData.context().getOrDefault(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, (Object)context.executionStrategy());
            assert (strategy != null);
            return new OuterRetryStrategy((Executor)(strategy.isRequestResponseOffloaded() ? context.executor() : context.ioExecutor()), requestMetaData);
        }

        public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
            return this.delegate().reserveConnection(metaData).retryWhen(this.retryStrategy(metaData, (ExecutionContext<HttpExecutionStrategy>)this.executionContext()));
        }

        protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
            StreamingHttpRequest duplicatedRequest = RetryingHttpRequesterFilter.this.mayReplayRequestPayload ? request.transformMessageBody(RetryingHttpRequesterFilter.messageBodyDuplicator()) : request;
            Single single = delegate.request(duplicatedRequest);
            if (RetryingHttpRequesterFilter.this.responseMapper != null) {
                single = single.flatMap(resp -> {
                    HttpResponseException exception = (HttpResponseException)RetryingHttpRequesterFilter.this.responseMapper.apply(resp);
                    return (exception != null ? resp.payloadBody().ignoreElements().onErrorComplete().concat(Single.failed((Throwable)exception)) : Single.succeeded((Object)resp)).shareContextOnSubscribe();
                });
            }
            return single.retryWhen(this.retryStrategy((HttpRequestMetaData)duplicatedRequest, (ExecutionContext<HttpExecutionStrategy>)this.executionContext()));
        }

        public Completable closeAsync() {
            if (this.closeAsync != null) {
                this.closeAsync.closeAsync();
            }
            return super.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            if (this.closeAsync != null) {
                this.closeAsync.closeAsyncGracefully();
            }
            return super.closeAsyncGracefully();
        }

        private final class OuterRetryStrategy
        implements BiIntFunction<Throwable, Completable> {
            private final Executor executor;
            private final HttpRequestMetaData requestMetaData;
            private int lbNotReadyCount;

            private OuterRetryStrategy(Executor executor, HttpRequestMetaData requestMetaData) {
                this.executor = executor;
                this.requestMetaData = requestMetaData;
            }

            public Completable apply(int count, Throwable t) {
                if (count > RetryingHttpRequesterFilter.this.maxTotalRetries) {
                    return Completable.failed((Throwable)t);
                }
                if (ContextAwareRetryingHttpClientFilter.this.loadBalancerReadySubscriber != null && t instanceof NoAvailableHostException) {
                    ++this.lbNotReadyCount;
                    Completable onHostsAvailable = ContextAwareRetryingHttpClientFilter.this.loadBalancerReadySubscriber.onHostsAvailable();
                    return ContextAwareRetryingHttpClientFilter.this.sdStatus == null ? onHostsAvailable : onHostsAvailable.ambWith(ContextAwareRetryingHttpClientFilter.this.sdStatus);
                }
                BackOffPolicy backOffPolicy = (BackOffPolicy)RetryingHttpRequesterFilter.this.retryFor.apply(this.requestMetaData, t);
                if (backOffPolicy != BackOffPolicy.NO_RETRIES) {
                    int offsetCount = count - this.lbNotReadyCount;
                    if (t instanceof DelayedRetry) {
                        Duration constant = ((DelayedRetry)((Object)t)).delay();
                        return ((Completable)backOffPolicy.newStrategy(this.executor).apply(offsetCount, (Object)t)).concat(this.executor.timer(constant));
                    }
                    return (Completable)backOffPolicy.newStrategy(this.executor).apply(offsetCount, (Object)t);
                }
                return Completable.failed((Throwable)t);
            }
        }
    }
}

