/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.TimeSource;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.internal.ThrowableUtils;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.AbstractTimeoutHttpFilter;
import io.servicetalk.transport.api.ExecutionContext;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public final class JavaNetSoTimeoutHttpConnectionFilter
implements StreamingHttpConnectionFilterFactory {
    private final BiFunction<HttpRequestMetaData, TimeSource, Duration> timeoutForRequest;
    @Nullable
    private final io.servicetalk.concurrent.api.Executor timeoutExecutor;

    public JavaNetSoTimeoutHttpConnectionFilter(Duration duration) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration));
    }

    public JavaNetSoTimeoutHttpConnectionFilter(Duration duration, io.servicetalk.concurrent.api.Executor timeoutExecutor) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), timeoutExecutor);
    }

    public JavaNetSoTimeoutHttpConnectionFilter(BiFunction<HttpRequestMetaData, TimeSource, Duration> timeoutForRequest) {
        this.timeoutForRequest = Objects.requireNonNull(timeoutForRequest);
        this.timeoutExecutor = null;
    }

    public JavaNetSoTimeoutHttpConnectionFilter(BiFunction<HttpRequestMetaData, TimeSource, Duration> timeoutForRequest, io.servicetalk.concurrent.api.Executor timeoutExecutor) {
        this.timeoutForRequest = Objects.requireNonNull(timeoutForRequest);
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
    }

    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return Single.defer(() -> {
                    io.servicetalk.concurrent.api.Executor timeoutExecutor = JavaNetSoTimeoutHttpConnectionFilter.this.contextExecutor((HttpRequestMetaData)request, (ExecutionContext<HttpExecutionStrategy>)((ExecutionContext)this.executionContext()));
                    Duration timeout = (Duration)JavaNetSoTimeoutHttpConnectionFilter.this.timeoutForRequest.apply(request, timeoutExecutor);
                    if (timeout == null) {
                        return this.delegate().request(request).shareContextOnSubscribe();
                    }
                    CompletableSource.Processor requestProcessor = Processors.newCompletableProcessor();
                    boolean expectContinue = request.headers().contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE);
                    Cancellable continueTimeout = expectContinue ? timeoutExecutor.schedule(() -> requestProcessor.onError((Throwable)JavaNetSoTimeoutHttpConnectionFilter.this.newStacklessSocketTimeoutException("Read timed out after " + timeout.toMillis() + "ms waiting for 100 (Continue) response")), timeout) : null;
                    return this.delegate().request(request.transformMessageBody(p -> {
                        Publisher body = p.beforeFinally(() -> ((CompletableSource.Processor)requestProcessor).onComplete());
                        if (continueTimeout != null) {
                            return body.beforeOnSubscribe(__ -> continueTimeout.cancel());
                        }
                        return body;
                    })).ambWith(SourceAdapters.fromSource((CompletableSource)requestProcessor).concat(Single.never().timeout(timeout, (Executor)timeoutExecutor).onErrorMap(TimeoutException.class, t -> JavaNetSoTimeoutHttpConnectionFilter.this.newStacklessSocketTimeoutException("Read timed out after " + timeout.toMillis() + "ms waiting for response meta-data").initCause((Throwable)t)))).map(response -> response.transformMessageBody(p -> p.timeout(timeout, (Executor)timeoutExecutor).onErrorMap(TimeoutException.class, t -> JavaNetSoTimeoutHttpConnectionFilter.this.newStacklessSocketTimeoutException("Read timed out after " + timeout.toMillis() + "ms waiting for the next response payload body chunk").initCause((Throwable)t)))).shareContextOnSubscribe();
                });
            }
        };
    }

    private io.servicetalk.concurrent.api.Executor contextExecutor(HttpRequestMetaData requestMetaData, ExecutionContext<HttpExecutionStrategy> context) {
        if (this.timeoutExecutor != null) {
            return this.timeoutExecutor;
        }
        HttpExecutionStrategy strategy = (HttpExecutionStrategy)requestMetaData.context().getOrDefault(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, (Object)context.executionStrategy());
        assert (strategy != null);
        return strategy.isMetadataReceiveOffloaded() || strategy.isDataReceiveOffloaded() ? context.executor() : context.ioExecutor();
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    private StacklessSocketTimeoutException newStacklessSocketTimeoutException(String message) {
        return StacklessSocketTimeoutException.newInstance(message, this.getClass(), "request");
    }

    private static final class StacklessSocketTimeoutException
    extends SocketTimeoutException {
        private static final long serialVersionUID = -6407427631101487627L;

        private StacklessSocketTimeoutException(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        static StacklessSocketTimeoutException newInstance(String message, Class<?> clazz, String method) {
            return (StacklessSocketTimeoutException)ThrowableUtils.unknownStackTrace((Throwable)new StacklessSocketTimeoutException(message), clazz, (String)method);
        }
    }
}

