/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.router.jersey.AbstractMessageBodyReaderWriter;
import io.servicetalk.http.router.jersey.internal.BufferPublisherInputStream;
import io.servicetalk.http.router.jersey.internal.RequestProperties;
import io.servicetalk.transport.api.ConnectionContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.ReaderWriter;

@Priority(value=4000)
@Produces(value={"*/*"})
final class BufferMessageBodyReaderWriter
implements MessageBodyReader<Buffer>,
MessageBodyWriter<Buffer> {
    @Context
    protected Provider<Ref<ConnectionContext>> ctxRefProvider;
    @Context
    private Provider<ContainerRequestContext> requestCtxProvider;

    BufferMessageBodyReaderWriter() {
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Buffer.class.isAssignableFrom(type);
    }

    public Buffer readFrom(Class<Buffer> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        return (Buffer)BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)((ConnectionContext)((Ref)this.ctxRefProvider.get()).get()).executionContext().bufferAllocator(), (p, a) -> {
            Buffer buf = AbstractMessageBodyReaderWriter.newBufferForRequestContent(AbstractMessageBodyReaderWriter.getRequestContentLength(this.requestCtxProvider), a);
            p.toIterable().forEach(arg_0 -> ((Buffer)buf).writeBytes(arg_0));
            return buf;
        }, (is, a) -> {
            int contentLength = AbstractMessageBodyReaderWriter.getRequestContentLength(this.requestCtxProvider);
            Buffer buf = contentLength == -1 ? a.newBuffer() : a.newBuffer(contentLength);
            try {
                int written = buf.writeBytesUntilEndStream(is, ReaderWriter.BUFFER_SIZE);
                if (contentLength > 0 && written != contentLength) {
                    throw new BadRequestException("Not enough bytes for content-length: " + contentLength + ", only got: " + written);
                }
                return buf;
            }
            catch (IOException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
        });
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !AbstractMessageBodyReaderWriter.isSse((ContainerRequestContext)this.requestCtxProvider.get()) && Buffer.class.isAssignableFrom(type);
    }

    public void writeTo(Buffer buffer, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) {
        httpHeaders.putSingle((Object)"Content-Length", (Object)buffer.readableBytes());
        RequestProperties.setResponseBufferPublisher((Publisher)Publisher.from((Object)buffer), (ContainerRequestContext)((ContainerRequestContext)this.requestCtxProvider.get()));
    }
}

