/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.env;

import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSFrameSlot;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.parser.env.DerivedEnvironment;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import java.util.Map;
import java.util.StringJoiner;
import org.graalvm.collections.EconomicMap;

public final class GlobalEnvironment
extends DerivedEnvironment {
    private final EconomicMap<TruffleString, Boolean> lexicalDeclarations = EconomicMap.create();
    private final EconomicMap<TruffleString, Boolean> varDeclarations = EconomicMap.create();

    public GlobalEnvironment(Environment parent, NodeFactory factory, JSContext context) {
        super(parent, factory, context);
    }

    @Override
    public JSFrameSlot findBlockFrameSlot(Object name) {
        return null;
    }

    public boolean addLexicalDeclaration(TruffleString name, boolean isConst) {
        return this.lexicalDeclarations.put((Object)name, (Object)isConst) == null;
    }

    public boolean hasLexicalDeclaration(TruffleString name) {
        return this.lexicalDeclarations.containsKey((Object)name);
    }

    public boolean hasConstDeclaration(TruffleString name) {
        return (Boolean)this.lexicalDeclarations.get((Object)name, (Object)Boolean.FALSE);
    }

    public boolean addVarDeclaration(TruffleString name) {
        return this.varDeclarations.put((Object)name, (Object)Boolean.FALSE) == null;
    }

    public boolean hasVarDeclaration(TruffleString name) {
        return this.varDeclarations.containsKey((Object)name);
    }

    public static boolean isGlobalObjectConstant(TruffleString name) {
        return Strings.UNDEFINED.equals((Object)name) || Strings.NAN.equals((Object)name) || Strings.INFINITY.equals((Object)name);
    }

    @Override
    protected String toStringImpl(Map<String, Integer> state) {
        return "Global" + new StringJoiner(", ", "{", "}").add(GlobalEnvironment.joinElements(this.lexicalDeclarations.getKeys())).add(GlobalEnvironment.joinElements(this.varDeclarations.getKeys())).toString();
    }
}

