/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.context.api;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface ContextMap {
    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Key<?> var1);

    public boolean containsValue(@Nullable Object var1);

    default public <T> boolean contains(Key<T> key, @Nullable T value) {
        T current = this.get(key);
        return current != null ? current.equals(value) : value == null && this.containsKey(key);
    }

    @Nullable
    public <T> T get(Key<T> var1);

    @Nullable
    default public <T> T getOrDefault(Key<T> key, T defaultValue) {
        T current = this.get(key);
        return current != null || this.containsKey(key) ? current : defaultValue;
    }

    @Nullable
    public <T> T put(Key<T> var1, @Nullable T var2);

    @Nullable
    default public <T> T putIfAbsent(Key<T> key, @Nullable T value) {
        T prev = this.get(key);
        if (prev == null) {
            prev = this.put(key, value);
        }
        return prev;
    }

    @Nullable
    default public <T> T computeIfAbsent(Key<T> key, Function<Key<T>, T> computeFunction) {
        T newValue;
        Objects.requireNonNull(computeFunction);
        T value = this.get(key);
        if (value == null && (newValue = computeFunction.apply(key)) != null) {
            this.put(key, newValue);
            return newValue;
        }
        return value;
    }

    default public void putAll(ContextMap map) {
        map.forEach((k, v) -> {
            this.put((Key)k, (Object)v);
            return true;
        });
    }

    default public void putAll(Map<Key<?>, Object> map) {
        map.forEach((? super K key, ? super V value) -> {
            Objects.requireNonNull(key);
            if (value != null && !key.type().isInstance(value)) {
                throw new IllegalArgumentException("Type of the value " + value + '(' + value.getClass() + ')' + " does mot match with " + key);
            }
        });
        map.forEach((? super K key, ? super V value) -> this.put((Key)key, (Object)value));
    }

    @Nullable
    public <T> T remove(Key<T> var1);

    default public boolean removeAll(Iterable<Key<?>> keys) {
        boolean removed = false;
        for (Key<?> k : keys) {
            boolean contains = this.containsKey(k);
            removed |= contains;
            if (!contains) continue;
            this.remove(k);
        }
        return removed;
    }

    public void clear();

    @Nullable
    public Key<?> forEach(BiPredicate<Key<?>, Object> var1);

    public ContextMap copy();

    public boolean equals(Object var1);

    public int hashCode();

    public static final class Key<T> {
        private final String name;
        private final Class<T> type;

        private Key(String name, Class<T> type) {
            this.name = Objects.requireNonNull(name);
            this.type = Objects.requireNonNull(type);
        }

        public String name() {
            return this.name;
        }

        public Class<T> type() {
            return this.type;
        }

        public static <T> Key<T> newKey(String name, Class<T> type) {
            return new Key<T>(name, type);
        }

        public String toString() {
            return "ContextMap.Key{name='" + this.name + '\'' + ", type=" + this.type.getSimpleName() + "}@" + Integer.toHexString(this.hashCode());
        }
    }
}

