/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

final class CancelPropagatingCompletableFuture<T>
extends CompletableFuture<T> {
    private final Cancellable cancellable;
    private final CompletableFuture<T> delegate;

    private CancelPropagatingCompletableFuture(CompletableFuture<T> delegate, Cancellable cancellable) {
        this.delegate = delegate;
        this.cancellable = cancellable;
    }

    static <T> CompletableFuture<T> newCancelPropagatingFuture(CompletableFuture<T> delegate, Cancellable cancellable) {
        CancelPropagatingCompletableFuture<T> future = new CancelPropagatingCompletableFuture<T>(delegate, cancellable);
        CancelPropagatingCompletableFuture.cascadeTermination(delegate, future);
        return future;
    }

    static <T> void cascadeTermination(CompletableFuture<T> delegate, CompletableFuture<T> outer) {
        delegate.whenComplete((T value, U throwable) -> {
            if (throwable == null) {
                outer.complete(value);
            } else if (throwable instanceof CancellationException) {
                outer.cancel(true);
            } else {
                outer.completeExceptionally((Throwable)throwable);
            }
        });
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenApply(fn), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenApplyAsync(fn), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenApplyAsync(fn, executor), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenAccept((Consumer)action), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenAcceptAsync((Consumer)action), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenAcceptAsync((Consumer)action, executor), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenRun(action), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenRunAsync(action), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenRunAsync(action, executor), this.cancellable);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenCombine(other, fn), this.cancellable);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenCombineAsync(other, fn), this.cancellable);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenCombineAsync(other, fn, executor), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenAcceptBoth(other, (BiConsumer)action), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenAcceptBothAsync(other, (BiConsumer)action), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenAcceptBothAsync(other, (BiConsumer)action, executor), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.runAfterBoth((CompletionStage)other, action), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.runAfterBothAsync((CompletionStage)other, action), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.runAfterBothAsync((CompletionStage)other, action, executor), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.applyToEither((CompletionStage)other, fn), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.applyToEitherAsync((CompletionStage)other, fn), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.applyToEitherAsync((CompletionStage)other, fn, executor), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.acceptEither((CompletionStage)other, (Consumer)action), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)action), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.runAfterEither((CompletionStage)other, action), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.runAfterEitherAsync((CompletionStage)other, action), this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.runAfterEitherAsync((CompletionStage)other, action, executor), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenCompose(fn), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenComposeAsync(fn), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.thenComposeAsync(fn, executor), this.cancellable);
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.exceptionally(fn), this.cancellable);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.whenComplete(action), this.cancellable);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.whenCompleteAsync(action), this.cancellable);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.whenCompleteAsync(action, executor), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.handle(fn), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.handleAsync(fn), this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(this.delegate.handleAsync(fn, executor), this.cancellable);
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.delegate.isCompletedExceptionally();
    }

    @Override
    @Nullable
    public T get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    @Nullable
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }

    @Override
    @Nullable
    public T join() {
        return this.delegate.join();
    }

    @Override
    @Nullable
    public T getNow(@Nullable T valueIfAbsent) {
        return this.delegate.getNow(valueIfAbsent);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            super.cancel(mayInterruptIfRunning);
            boolean bl = this.delegate.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            this.cancellable.cancel();
        }
    }

    @Override
    public boolean complete(T value) {
        try {
            super.complete(value);
            boolean bl = this.delegate.complete(value);
            return bl;
        }
        finally {
            this.cancellable.cancel();
        }
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        try {
            super.completeExceptionally(ex);
            boolean bl = this.delegate.completeExceptionally(ex);
            return bl;
        }
        finally {
            this.cancellable.cancel();
        }
    }

    @Override
    public void obtrudeValue(T value) {
        try {
            super.obtrudeValue(value);
            this.delegate.obtrudeValue(value);
        }
        finally {
            this.cancellable.cancel();
        }
    }

    @Override
    public void obtrudeException(Throwable ex) {
        try {
            super.obtrudeException(ex);
            this.delegate.obtrudeException(ex);
        }
        finally {
            this.cancellable.cancel();
        }
    }

    @Override
    public int getNumberOfDependents() {
        return this.delegate.getNumberOfDependents();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

