/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;

class ContextPreservingCompletableSubscriber
implements CompletableSource.Subscriber {
    final ContextMap saved;
    final CompletableSource.Subscriber subscriber;

    ContextPreservingCompletableSubscriber(CompletableSource.Subscriber subscriber, ContextMap current) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.saved = Objects.requireNonNull(current);
    }

    void invokeOnSubscribe(Cancellable cancellable) {
        this.subscriber.onSubscribe(cancellable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSubscribe(Cancellable cancellable) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)currentThread;
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.invokeOnSubscribe(cancellable);
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.onSubscribeSlowPath(cancellable);
        }
    }

    private void onSubscribeSlowPath(Cancellable cancellable) {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.invokeOnSubscribe(cancellable);
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onComplete() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)currentThread;
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.subscriber.onComplete();
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.onCompleteSlowPath();
        }
    }

    private void onCompleteSlowPath() {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.subscriber.onComplete();
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onError(Throwable t) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)currentThread;
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.subscriber.onError(t);
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.onErrorSlowPath(t);
        }
    }

    private void onErrorSlowPath(Throwable t) {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.subscriber.onError(t);
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscriber + ')';
    }
}

