/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.api.BlockingProcessorSignalsHolder;
import io.servicetalk.concurrent.api.ProcessorSignalsConsumer;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

final class DefaultBlockingIterableProcessor<T>
implements BlockingIterable.Processor<T> {
    private final BlockingProcessorSignalsHolder<T> buffer;

    DefaultBlockingIterableProcessor(BlockingProcessorSignalsHolder<T> buffer) {
        this.buffer = Objects.requireNonNull(buffer);
    }

    public BlockingIterator<T> iterator() {
        return new PollingBlockingIterator<T>(this.buffer);
    }

    public void next(@Nullable T nextItem) throws InterruptedException {
        this.buffer.add(nextItem);
    }

    public void fail(Throwable cause) throws InterruptedException {
        this.buffer.terminate(cause);
    }

    public void close() throws InterruptedException {
        this.buffer.terminate();
    }

    private static final class PollingBlockingIterator<T>
    implements BlockingIterator<T>,
    ProcessorSignalsConsumer<T> {
        @Nullable
        private T next;
        @Nullable
        private TerminalNotification terminal;
        private final BlockingProcessorSignalsHolder<T> buffer;

        PollingBlockingIterator(BlockingProcessorSignalsHolder<T> buffer) {
            this.buffer = buffer;
        }

        public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
            boolean consumed;
            if (this.terminal != null) {
                return this.hasNextWhenTerminated();
            }
            if (this.next != null) {
                return true;
            }
            try {
                consumed = this.buffer.consume(this, timeout, unit);
            }
            catch (InterruptedException e) {
                return (Boolean)PlatformDependent.throwException((Throwable)e);
            }
            return this.terminal == null ? consumed : this.hasNextWhenTerminated();
        }

        @Nullable
        public T next(long timeout, TimeUnit unit) throws TimeoutException {
            if (!this.hasNext(timeout, unit)) {
                throw new NoSuchElementException();
            }
            return this.processNext();
        }

        @Nullable
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.processNext();
        }

        public void close() {
            this.terminal = TerminalNotification.error((Throwable)new CancellationException());
        }

        public boolean hasNext() {
            boolean consumed;
            if (this.terminal != null) {
                return this.hasNextWhenTerminated();
            }
            if (this.next != null) {
                return true;
            }
            try {
                consumed = this.buffer.consume(this);
            }
            catch (InterruptedException e) {
                return (Boolean)PlatformDependent.throwException((Throwable)e);
            }
            return this.terminal == null ? consumed : this.hasNextWhenTerminated();
        }

        private boolean hasNextWhenTerminated() {
            assert (this.terminal != null);
            Throwable cause = this.terminal.cause();
            if (cause != null) {
                PlatformDependent.throwException((Throwable)cause);
            }
            return false;
        }

        @Nullable
        private T processNext() {
            T next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void consumeItem(@Nullable T item) {
            this.next = item;
        }

        @Override
        public void consumeTerminal(Throwable cause) {
            this.terminal = TerminalNotification.error((Throwable)cause);
        }

        @Override
        public void consumeTerminal() {
            this.terminal = TerminalNotification.complete();
        }
    }
}

