package org.apache.baremaps.ogcapi.api;

import org.apache.baremaps.ogcapi.model.Exception;
import java.io.File;
import org.apache.baremaps.ogcapi.model.TileSet;
import org.apache.baremaps.ogcapi.model.TileSets;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;

import io.swagger.annotations.*;

import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/tiles")
@Api(description = "the tiles API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public interface TilesApi {

    @GET
    @Path("/{tileSetId}/{tileMatrix}/{tileRow}/{tileCol}")
    @Produces({ "application/vnd.mapbox-vector-tile", "application/json" })
    @ApiOperation(value = "Retrieve a vector tile including one or more collections from the dataset.", notes = "", tags={ "Vector Tiles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "A vector tile returned as a response.", response = File.class),
        @ApiResponse(code = 204, message = "No data available for this tile.", response = Void.class),
        @ApiResponse(code = 404, message = "The requested resource does not exist on the server. For example, a path parameter had an incorrect value.", response = Exception.class),
        @ApiResponse(code = 500, message = "A server error occurred.", response = Exception.class) })
    Response getTile(@PathParam("tileSetId") @ApiParam("Identifier for a supported TileMatrixSet") String tileSetId,@PathParam("tileMatrix") @ApiParam("Identifier selecting one of the scales defined in the TileMatrixSet and representing the scaleDenominator the tile. For example, Ireland is fully within the Tile at WebMercatorQuad tileMatrix&#x3D;5, tileRow&#x3D;10 and tileCol&#x3D;15.") String tileMatrix,@PathParam("tileRow") @Min(0) @ApiParam("Row index of the tile on the selected TileMatrix. It cannot exceed the MatrixWidth-1 for the selected TileMatrix. For example, Ireland is fully within the Tile at WebMercatorQuad tileMatrix&#x3D;5, tileRow&#x3D;10 and tileCol&#x3D;15.") Integer tileRow,@PathParam("tileCol") @Min(0) @ApiParam("Column index of the tile on the selected TileMatrix. It cannot exceed the MatrixHeight-1 for the selected TileMatrix. For example, Ireland is fully within the Tile at WebMercatorQuad tileMatrix&#x3D;5, tileRow&#x3D;10 and tileCol&#x3D;15.") Integer tileCol);

    @GET
    @Path("/{tileSetId}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Retrieve the vector tileSet metadata for the whole dataset and the specified tiling scheme (tile matrix set)", notes = "", tags={ "Vector Tiles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Description of the tileSet", response = TileSet.class),
        @ApiResponse(code = 404, message = "The requested resource does not exist on the server. For example, a path parameter had an incorrect value.", response = Exception.class),
        @ApiResponse(code = 500, message = "A server error occurred.", response = Exception.class) })
    Response getTileSet(@PathParam("tileSetId") @ApiParam("Identifier for a supported TileMatrixSet") String tileSetId);

    @GET
    @Produces({ "application/json" })
    @ApiOperation(value = "Retrieve a list of available vector tileSets for the dataset", notes = "", tags={ "Vector Tiles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "List of available tileSets.", response = TileSets.class),
        @ApiResponse(code = 404, message = "The requested resource does not exist on the server. For example, a path parameter had an incorrect value.", response = Exception.class),
        @ApiResponse(code = 500, message = "A server error occurred.", response = Exception.class) })
    Response getTileSets();
}
