/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.collection;

import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.baremaps.database.collection.DataList;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.database.collection.MemoryAlignedDataList;
import org.apache.baremaps.database.type.LongDataType;

public class MonotonicFixedSizeDataMap<E>
extends DataMap<Long, E> {
    private final DataList<Long> offsets;
    private final DataList<Long> keys;
    private final DataList<E> values;
    private long lastChunk = -1L;

    public MonotonicFixedSizeDataMap(DataList<E> values) {
        this(new MemoryAlignedDataList<Long>(new LongDataType()), new MemoryAlignedDataList<Long>(new LongDataType()), values);
    }

    public MonotonicFixedSizeDataMap(DataList<Long> offsets, DataList<Long> keys, DataList<E> values) {
        this.offsets = offsets;
        this.keys = keys;
        this.values = values;
    }

    @Override
    public E get(Object keyObject) {
        long key = (Long)keyObject;
        long chunk = key >>> 8;
        if (chunk >= (long)this.offsets.size()) {
            return null;
        }
        long lo = this.offsets.get(chunk);
        long hi = Math.min(this.keys.sizeAsLong(), chunk >= this.offsets.sizeAsLong() - 1L ? this.keys.sizeAsLong() : this.offsets.get(chunk + 1L).longValue()) - 1L;
        while (lo <= hi) {
            long index = lo + hi >>> 1;
            long value = this.keys.get(index);
            if (value < key) {
                lo = index + 1L;
                continue;
            }
            if (value > key) {
                hi = index - 1L;
                continue;
            }
            return this.values.get(index);
        }
        return null;
    }

    @Override
    public E put(Long key, E value) {
        long size = this.keys.sizeAsLong();
        long chunk = key >>> 8;
        if (chunk != this.lastChunk) {
            while (this.offsets.sizeAsLong() <= chunk) {
                this.offsets.add(size);
            }
            this.lastChunk = chunk;
        }
        this.keys.add(key);
        this.values.add(value);
        return null;
    }

    @Override
    public E remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long sizeAsLong() {
        return this.keys.sizeAsLong();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    protected Iterator<Long> keyIterator() {
        return this.keys.iterator();
    }

    @Override
    protected Iterator<E> valueIterator() {
        return this.values.iterator();
    }

    @Override
    protected Iterator<Map.Entry<Long, E>> entryIterator() {
        return Streams.zip((Stream)Streams.stream(this.keyIterator()), (Stream)Streams.stream(this.valueIterator()), (k, v) -> Map.entry(k, v)).iterator();
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.keys.clear();
        this.values.clear();
    }
}

