/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.function.Function;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.IndexableField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;

public class OpenstreetmapDocumentMapper
implements Function<Element, Document> {
    @Override
    public Document apply(Element element) {
        Document document = new Document();
        document.add((IndexableField)new StoredField("id", element.getId()));
        element.getTags().forEach((key, value) -> document.add((IndexableField)new StoredField(key, value.toString())));
        Geometry geometry = element.getGeometry();
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            document.add((IndexableField)LatLonShape.createDocValueField((String)"geometry", (double)point.getY(), (double)point.getX()));
        } else if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            Coordinate[] coordinates = lineString.getCoordinates();
            double[] lats = new double[coordinates.length];
            double[] lons = new double[coordinates.length];
            for (int i = 0; i < coordinates.length; ++i) {
                lats[i] = coordinates[i].y;
                lons[i] = coordinates[i].x;
            }
            document.add((IndexableField)LatLonShape.createDocValueField((String)"geometry", (Line)new Line(lats, lons)));
        } else if (geometry instanceof org.locationtech.jts.geom.Polygon) {
            org.locationtech.jts.geom.Polygon polygon = (org.locationtech.jts.geom.Polygon)geometry;
            Coordinate[] coordinates = polygon.getCoordinates();
            double[] lats = new double[coordinates.length];
            double[] lons = new double[coordinates.length];
            for (int i = 0; i < coordinates.length; ++i) {
                lats[i] = coordinates[i].y;
                lons[i] = coordinates[i].x;
            }
            document.add((IndexableField)LatLonShape.createDocValueField((String)"geometry", (Polygon)new Polygon(lats, lons, new Polygon[0])));
        } else if (geometry instanceof MultiPolygon) {
            // empty if block
        }
        return document;
    }
}

