/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.postgres;

import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.baremaps.postgres.metadata.DatabaseMetadata;
import org.apache.baremaps.postgres.metadata.TableMetadata;
import org.apache.baremaps.vectortile.tileset.TilesetQuery;

public class PostgresQueryGenerator {
    private final String catalog;
    private final String schemaPattern;
    private final String tableNamePattern;
    private final String columnNamePattern;
    private final String[] types;
    private final DataSource dataSource;

    public PostgresQueryGenerator(DataSource dataSource) {
        this(dataSource, null, null, null, null, new String[0]);
    }

    public PostgresQueryGenerator(DataSource dataSource, String catalog, String schemaPattern, String typeNamePattern, String columnNamePattern, String ... types) {
        this.dataSource = dataSource;
        this.catalog = catalog;
        this.schemaPattern = schemaPattern;
        this.tableNamePattern = typeNamePattern;
        this.columnNamePattern = columnNamePattern;
        this.types = types;
    }

    public List<TilesetQuery> generate() {
        return new DatabaseMetadata(this.dataSource).getTableMetaData(this.catalog, this.schemaPattern, this.tableNamePattern, this.types).stream().filter(table -> table.primaryKeys().size() == 1).filter(table -> table.getGeometryColumns().size() == 1).map(this::getLayer).toList();
    }

    private TilesetQuery getLayer(TableMetadata table) {
        String tableSchema = table.table().tableSchem();
        String tableName = table.table().tableName();
        String layer = String.format("%s.%s", tableSchema, tableName);
        String idColumn = table.primaryKeys().get(0).columnName();
        String geometryColumn = table.getGeometryColumns().get(0).columnName();
        String tagsColumns = table.columns().stream().filter(column -> !idColumn.equals(column.columnName())).filter(column -> !geometryColumn.equals(column.columnName())).map(column -> String.format("'%1$s', %1$s::text", column.columnName())).collect(Collectors.joining(", ", "hstore(array[", "])"));
        String sql = String.format("SELECT %s, %s, %s FROM %s", idColumn, tagsColumns, geometryColumn, tableName);
        return new TilesetQuery(0, 20, sql);
    }
}

