/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.vectortile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.baremaps.mvt.binary.VectorTile;
import org.apache.baremaps.vectortile.Feature;
import org.apache.baremaps.vectortile.Layer;
import org.apache.baremaps.vectortile.Tile;
import org.apache.baremaps.vectortile.VectorTileFunctions;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class VectorTileEncoder {
    private int cx = 0;
    private int cy = 0;
    private List<String> keys = new ArrayList<String>();
    private List<Object> values = new ArrayList<Object>();

    public VectorTile.Tile encodeTile(Tile tile) {
        VectorTile.Tile.Builder builder = VectorTile.Tile.newBuilder();
        tile.getLayers().forEach(layer -> builder.addLayers(this.encodeLayer((Layer)layer)));
        return builder.build();
    }

    public VectorTile.Tile.Layer encodeLayer(Layer layer) {
        this.keys = new ArrayList<String>();
        this.values = new ArrayList<Object>();
        VectorTile.Tile.Layer.Builder builder = VectorTile.Tile.Layer.newBuilder();
        builder.setName(layer.getName());
        builder.setVersion(2);
        builder.setExtent(layer.getExtent());
        layer.getFeatures().stream().forEach(feature -> this.encodeFeature((Feature)feature, builder::addFeatures));
        builder.addAllKeys(this.keys);
        builder.addAllValues(this.values.stream().map(this::encodeValue).toList());
        return builder.build();
    }

    protected VectorTile.Tile.Value encodeValue(Object object) {
        VectorTile.Tile.Value.Builder builder = VectorTile.Tile.Value.newBuilder();
        if (object instanceof String) {
            String value = (String)object;
            builder.setStringValue(value);
        } else if (object instanceof Float) {
            Float value = (Float)object;
            builder.setFloatValue(value.floatValue());
        } else if (object instanceof Double) {
            Double value = (Double)object;
            builder.setDoubleValue(value);
        } else if (object instanceof Integer) {
            Integer value = (Integer)object;
            builder.setIntValue(value.intValue());
        } else if (object instanceof Long) {
            Long value = (Long)object;
            builder.setIntValue(value);
        } else if (object instanceof Boolean) {
            Boolean value = (Boolean)object;
            builder.setBoolValue(value);
        }
        return builder.build();
    }

    protected void encodeFeature(Feature feature, Consumer<VectorTile.Tile.Feature> consumer) {
        this.cx = 0;
        this.cy = 0;
        VectorTile.Tile.Feature.Builder builder = VectorTile.Tile.Feature.newBuilder();
        builder.setId(feature.getId());
        builder.setType(this.encodeGeometryType(feature.getGeometry()));
        this.encodeTag(feature.getTags(), builder::addTags);
        this.encodeGeometry(feature.getGeometry(), builder::addGeometry);
        consumer.accept(builder.build());
    }

    protected VectorTile.Tile.GeomType encodeGeometryType(Geometry geometry) {
        if (geometry instanceof Point) {
            return VectorTile.Tile.GeomType.POINT;
        }
        if (geometry instanceof MultiPoint) {
            return VectorTile.Tile.GeomType.POINT;
        }
        if (geometry instanceof LineString) {
            return VectorTile.Tile.GeomType.LINESTRING;
        }
        if (geometry instanceof MultiLineString) {
            return VectorTile.Tile.GeomType.LINESTRING;
        }
        if (geometry instanceof Polygon) {
            return VectorTile.Tile.GeomType.POLYGON;
        }
        if (geometry instanceof MultiPolygon) {
            return VectorTile.Tile.GeomType.POLYGON;
        }
        return VectorTile.Tile.GeomType.UNKNOWN;
    }

    protected void encodeTag(Map<String, Object> tags, Consumer<Integer> encoding) {
        for (Map.Entry<String, Object> tag : tags.entrySet()) {
            int valueIndex;
            int keyIndex = this.keys.indexOf(tag.getKey());
            if (keyIndex == -1) {
                keyIndex = this.keys.size();
                this.keys.add(tag.getKey());
            }
            if ((valueIndex = this.values.indexOf(tag.getValue())) == -1) {
                valueIndex = this.values.size();
                this.values.add(tag.getValue());
            }
            encoding.accept(keyIndex);
            encoding.accept(valueIndex);
        }
    }

    protected void encodeGeometry(Geometry geometry, Consumer<Integer> encoding) {
        if (geometry instanceof Point) {
            this.encodePoint((Point)geometry, encoding);
        } else if (geometry instanceof MultiPoint) {
            this.encodeMultiPoint((MultiPoint)geometry, encoding);
        } else if (geometry instanceof LineString) {
            this.encodeLineString((LineString)geometry, encoding);
        } else if (geometry instanceof MultiLineString) {
            this.encodeMultiLineString((MultiLineString)geometry, encoding);
        } else if (geometry instanceof Polygon) {
            this.encodePolygon((Polygon)geometry, encoding);
        } else if (geometry instanceof MultiPolygon) {
            this.encodeMultiPolygon((MultiPolygon)geometry, encoding);
        } else if (geometry instanceof GeometryCollection) {
            throw new UnsupportedOperationException("GeometryCollection not supported");
        }
    }

    protected void encodePoint(Point point, Consumer<Integer> encoding) {
        encoding.accept(VectorTileEncoder.command(1, 1));
        Coordinate coordinate = point.getCoordinate();
        int dx = (int)Math.round(coordinate.getX()) - this.cx;
        int dy = (int)Math.round(coordinate.getY()) - this.cy;
        encoding.accept(VectorTileEncoder.parameter(dx));
        encoding.accept(VectorTileEncoder.parameter(dy));
        this.cx += dx;
        this.cy += dy;
    }

    protected void encodeMultiPoint(MultiPoint multiPoint, Consumer<Integer> encoding) {
        List<Coordinate> coordinates = List.of(multiPoint.getCoordinates());
        encoding.accept(VectorTileEncoder.command(1, coordinates.size()));
        this.encodeCoordinates(coordinates, encoding);
    }

    protected void encodeLineString(LineString lineString, Consumer<Integer> encoding) {
        List<Coordinate> coordinates = List.of(lineString.getCoordinates());
        encoding.accept(VectorTileEncoder.command(1, 1));
        this.encodeCoordinates(coordinates.subList(0, 1), encoding);
        encoding.accept(VectorTileEncoder.command(2, coordinates.size() - 1));
        this.encodeCoordinates(coordinates.subList(1, coordinates.size()), encoding);
    }

    protected void encodeMultiLineString(MultiLineString multiLineString, Consumer<Integer> encoding) {
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            Geometry geometry = multiLineString.getGeometryN(i);
            if (!(geometry instanceof LineString)) continue;
            LineString lineString = (LineString)geometry;
            this.encodeLineString(lineString, encoding);
        }
    }

    protected void encodePolygon(Polygon polygon, Consumer<Integer> encoding) {
        LinearRing exteriorRing = polygon.getExteriorRing();
        List exteriorRingCoordinates = List.of(exteriorRing.getCoordinates());
        if (!VectorTileFunctions.isClockWise((Geometry)exteriorRing)) {
            exteriorRingCoordinates = Lists.reverse(exteriorRingCoordinates);
        }
        this.encodeRing(exteriorRingCoordinates, encoding);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing interiorRing = polygon.getInteriorRingN(i);
            List interiorRingCoordinates = List.of(interiorRing.getCoordinates());
            if (VectorTileFunctions.isClockWise((Geometry)interiorRing)) {
                interiorRingCoordinates = Lists.reverse((List)exteriorRingCoordinates);
            }
            this.encodeRing(interiorRingCoordinates, encoding);
        }
    }

    protected void encodeRing(List<Coordinate> coordinates, Consumer<Integer> encoding) {
        List<Coordinate> head = coordinates.subList(0, 1);
        encoding.accept(VectorTileEncoder.command(1, 1));
        this.encodeCoordinates(head, encoding);
        List<Coordinate> tail = coordinates.subList(1, coordinates.size() - 1);
        encoding.accept(VectorTileEncoder.command(2, tail.size()));
        this.encodeCoordinates(tail, encoding);
        encoding.accept(VectorTileEncoder.command(7, 1));
    }

    protected void encodeMultiPolygon(MultiPolygon multiPolygon, Consumer<Integer> encoding) {
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Geometry geometry = multiPolygon.getGeometryN(i);
            if (!(geometry instanceof Polygon)) continue;
            Polygon polygon = (Polygon)geometry;
            this.encodePolygon(polygon, encoding);
        }
    }

    protected void encodeCoordinates(List<Coordinate> coordinates, Consumer<Integer> encoding) {
        for (Coordinate coordinate : coordinates) {
            int dx = (int)Math.round(coordinate.getX()) - this.cx;
            int dy = (int)Math.round(coordinate.getY()) - this.cy;
            encoding.accept(VectorTileEncoder.parameter(dx));
            encoding.accept(VectorTileEncoder.parameter(dy));
            this.cx += dx;
            this.cy += dy;
        }
    }

    protected static int command(int id, int count) {
        return id & 7 | count << 3;
    }

    protected static int parameter(int value) {
        return value << 1 ^ value >> 31;
    }
}

