/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.StringJoiner;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompressFile
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(DecompressFile.class);
    private Path source;
    private Path target;
    private Compression compression;

    public DecompressFile() {
    }

    public DecompressFile(Path source, Path target, Compression compression) {
        this.source = source;
        this.target = target;
        this.compression = compression;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path sourcePath = this.source.toAbsolutePath();
        Path targetPath = this.target.toAbsolutePath();
        switch (this.compression) {
            case zip: {
                DecompressFile.decompressZip(sourcePath, targetPath);
                break;
            }
            case targz: {
                DecompressFile.decompressTarGz(sourcePath, targetPath);
                break;
            }
            case tarbz2: {
                DecompressFile.decompressTarBz2(sourcePath, targetPath);
                break;
            }
            case gzip: {
                DecompressFile.decompressGzip(sourcePath, targetPath);
                break;
            }
            case bzip2: {
                DecompressFile.decompressBzip2(sourcePath, targetPath);
            }
        }
    }

    protected static void decompressBzip2(Path source, Path target) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             BZip2CompressorInputStream bzip2InputStream = new BZip2CompressorInputStream((InputStream)bufferedInputStream);){
            Files.copy((InputStream)bzip2InputStream, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected static void decompressGzip(Path source, Path target) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             GZIPInputStream zis = new GZIPInputStream(bufferedInputStream);){
            Files.copy(zis, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected static void decompressTarGz(Path source, Path target) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             GZIPInputStream gzipInputStream = new GZIPInputStream(bufferedInputStream);
             TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)gzipInputStream);){
            TarArchiveEntry entry;
            while ((entry = tarInputStream.getNextEntry()) != null) {
                Path path = target.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(path, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, new byte[0], StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                    tarInputStream.transferTo((OutputStream)outputStream);
                }
            }
        }
    }

    protected static void decompressTarBz2(Path source, Path target) throws IOException {
        Files.createDirectories(target, new FileAttribute[0]);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             BZip2CompressorInputStream bzip2InputStream = new BZip2CompressorInputStream((InputStream)bufferedInputStream);
             TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)bzip2InputStream);){
            TarArchiveEntry entry;
            while ((entry = tarInputStream.getNextEntry()) != null) {
                Path path = target.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(path, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, new byte[0], StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                    tarInputStream.transferTo((OutputStream)outputStream);
                }
            }
        }
    }

    protected static void decompressZip(Path source, Path target) throws IOException {
        Files.createDirectories(target, new FileAttribute[0]);
        try (ZipFile zipFile = new ZipFile(source.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Path path = target.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(path, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, new byte[0], StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                try (BufferedInputStream input = new BufferedInputStream(zipFile.getInputStream(entry));
                     BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path.toFile()));){
                    input.transferTo(output);
                }
            }
        }
    }

    public String toString() {
        return new StringJoiner(", ", DecompressFile.class.getSimpleName() + "[", "]").add("source=" + this.source).add("target=" + this.target).add("compression=" + this.compression).toString();
    }

    public static enum Compression {
        zip,
        targz,
        tarbz2,
        gzip,
        bzip2;

    }
}

