/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.StringJoiner;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUrl
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(DownloadUrl.class);
    private static final String PROTOCOL_FTP = "ftp";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private String source;
    private Path target;
    private boolean replaceExisting = true;

    public DownloadUrl() {
    }

    public DownloadUrl(String source, Path target, boolean replaceExisting) {
        this.source = source;
        this.target = target;
        this.replaceExisting = replaceExisting;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        URL sourceURL = new URL(this.source);
        Path targetPath = this.target.toAbsolutePath();
        if (Files.exists(targetPath, new LinkOption[0]) && !this.replaceExisting) {
            logger.info("Skipping download of {} to {}", (Object)this.source, (Object)this.target);
            return;
        }
        if (DownloadUrl.isHttp(sourceURL)) {
            HttpURLConnection get = (HttpURLConnection)sourceURL.openConnection();
            get.setInstanceFollowRedirects(true);
            get.setRequestMethod("GET");
            DownloadUrl.urlDownloadToFile(get, targetPath);
            get.disconnect();
        } else if (DownloadUrl.isFtp(sourceURL)) {
            DownloadUrl.urlDownloadToFile(sourceURL.openConnection(), targetPath);
        } else {
            throw new IllegalArgumentException("Unsupported URL protocol (supported: http(s)/ftp)");
        }
    }

    private static boolean isHttp(URL url) {
        return url.getProtocol().equalsIgnoreCase(PROTOCOL_HTTP) || url.getProtocol().equalsIgnoreCase(PROTOCOL_HTTPS);
    }

    private static boolean isFtp(URL url) {
        return url.getProtocol().equalsIgnoreCase(PROTOCOL_FTP);
    }

    private static void urlDownloadToFile(URLConnection url, Path targetPath) throws IOException {
        try (InputStream inputStream = url.getInputStream();){
            Files.createDirectories(targetPath.toAbsolutePath().getParent(), new FileAttribute[0]);
            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public String toString() {
        return new StringJoiner(", ", DownloadUrl.class.getSimpleName() + "[", "]").add("source='" + this.source + "'").add("target=" + this.target).add("replaceExisting=" + this.replaceExisting).toString();
    }
}

