/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.sql.DataSource;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.postgres.PostgresNodeRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresRelationRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresWayRepository;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportDaylightFeatures
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ImportDaylightFeatures.class);
    private Path file;
    private Object database;

    public ImportDaylightFeatures() {
    }

    public ImportDaylightFeatures(Path file, Object database) {
        this.file = file;
        this.database = database;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        DataSource datasource = context.getDataSource(this.database);
        PostgresNodeRepository nodeRepository = new PostgresNodeRepository(datasource);
        PostgresWayRepository wayRepository = new PostgresWayRepository(datasource);
        PostgresRelationRepository relationRepository = new PostgresRelationRepository(datasource);
        nodeRepository.create();
        wayRepository.create();
        relationRepository.create();
        ObjectMapper objectMapper = new ObjectMapper();
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{Feature.class});
        List features = (List)objectMapper.readValue(this.file.toFile(), javaType);
        block10: for (Feature feature : features) {
            switch (feature.type()) {
                case "node": {
                    Node node = nodeRepository.get(feature.id());
                    if (node == null) continue block10;
                    HashMap<String, Object> tags = new HashMap<String, Object>(feature.tags());
                    if (node.getTags() != null) {
                        tags.putAll(node.getTags());
                    }
                    node.setTags(tags);
                    nodeRepository.put(node);
                    break;
                }
                case "way": {
                    Way way = wayRepository.get(feature.id());
                    if (way == null) continue block10;
                    HashMap<String, Object> tags = new HashMap<String, Object>(feature.tags());
                    if (way.getTags() != null) {
                        tags.putAll(way.getTags());
                    }
                    way.setTags(tags);
                    wayRepository.put(way);
                    break;
                }
                case "relation": {
                    Relation relation = relationRepository.get(feature.id());
                    if (relation == null) break;
                    HashMap<String, Object> tags = new HashMap<String, Object>(feature.tags());
                    if (relation.getTags() != null) {
                        tags.putAll(relation.getTags());
                    }
                    relation.setTags(tags);
                    relationRepository.put(relation);
                }
            }
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportDaylightFeatures.class.getSimpleName() + "[", "]").add("file=" + this.file).add("database=" + this.database).toString();
    }

    record Feature(@JsonProperty(value="osm_type") String type, @JsonProperty(value="osm_id") Long id, @JsonProperty(value="tags") Map<String, Object> tags, @JsonProperty(value="wkt") String wkt, @JsonProperty(value="category") String category) {
    }
}

