/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Path;
import java.util.StringJoiner;
import javax.sql.DataSource;
import org.apache.baremaps.database.schema.DataTable;
import org.apache.baremaps.database.schema.DataTableAdapter;
import org.apache.baremaps.database.schema.DataTableGeometryTransformer;
import org.apache.baremaps.storage.geopackage.GeoPackageDataSchema;
import org.apache.baremaps.storage.postgres.PostgresDataSchema;
import org.apache.baremaps.utils.ProjectionTransformer;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportGeoPackage
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ImportGeoPackage.class);
    private Path file;
    private Integer fileSrid;
    private Object database;
    private Integer databaseSrid;

    public ImportGeoPackage() {
    }

    public ImportGeoPackage(Path file, Integer fileSrid, Object database, Integer databaseSrid) {
        this.file = file;
        this.fileSrid = fileSrid;
        this.database = database;
        this.databaseSrid = databaseSrid;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path path = this.file.toAbsolutePath();
        try (GeoPackageDataSchema geoPackageDataStore = new GeoPackageDataSchema(path);){
            DataSource dataSource = context.getDataSource(this.database);
            PostgresDataSchema postgresDataStore = new PostgresDataSchema(dataSource);
            for (String name : geoPackageDataStore.list()) {
                DataTable geoPackageTable = geoPackageDataStore.get(name);
                ProjectionTransformer projectionTransformer = new ProjectionTransformer(this.fileSrid, this.databaseSrid);
                DataTableGeometryTransformer rowTransformer = new DataTableGeometryTransformer(geoPackageTable, projectionTransformer);
                DataTableAdapter transformedDataTable = new DataTableAdapter(geoPackageDataStore.get(name), rowTransformer);
                postgresDataStore.add(transformedDataTable);
            }
        }
        catch (Exception e) {
            throw new WorkflowException(e);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportGeoPackage.class.getSimpleName() + "[", "]").add("file=" + this.file).add("fileSrid=" + this.fileSrid).add("database=" + this.database).add("databaseSrid=" + this.databaseSrid).toString();
    }
}

