/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.BufferedInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.sql.DataSource;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.openstreetmap.function.ChangeEntitiesHandler;
import org.apache.baremaps.openstreetmap.function.CoordinateMapBuilder;
import org.apache.baremaps.openstreetmap.function.EntityGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.EntityProjectionTransformer;
import org.apache.baremaps.openstreetmap.function.ReferenceMapBuilder;
import org.apache.baremaps.openstreetmap.model.Change;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.postgres.PostgresNodeRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresRelationRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresWayRepository;
import org.apache.baremaps.openstreetmap.repository.CopyChangeImporter;
import org.apache.baremaps.openstreetmap.xml.XmlChangeReader;
import org.apache.baremaps.stream.ConsumerUtils;
import org.apache.baremaps.utils.Compression;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportOsmOsc
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ImportOsmOsc.class);
    private Path file;
    private Compression compression;
    private Object database;
    private Integer databaseSrid;

    public ImportOsmOsc() {
    }

    public ImportOsmOsc(Path file, Compression compression, Object database, Integer databaseSrid) {
        this.file = file;
        this.compression = compression;
        this.database = database;
        this.databaseSrid = databaseSrid;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path path = this.file.toAbsolutePath();
        DataSource datasource = context.getDataSource(this.database);
        PostgresNodeRepository nodeRepository = new PostgresNodeRepository(datasource);
        PostgresWayRepository wayRepository = new PostgresWayRepository(datasource);
        PostgresRelationRepository relationRepository = new PostgresRelationRepository(datasource);
        DataMap<Long, Coordinate> coordinateMap = context.getCoordinateMap();
        DataMap<Long, List<Long>> referenceMap = context.getReferenceMap();
        CoordinateMapBuilder coordinateMapBuilder = new CoordinateMapBuilder(coordinateMap);
        ReferenceMapBuilder referenceMapBuilder = new ReferenceMapBuilder(referenceMap);
        EntityGeometryBuilder buildGeometry = new EntityGeometryBuilder(coordinateMap, referenceMap);
        EntityProjectionTransformer reprojectGeometry = new EntityProjectionTransformer(4326, this.databaseSrid);
        Consumer<Entity> prepareGeometries = coordinateMapBuilder.andThen(referenceMapBuilder).andThen(buildGeometry).andThen(reprojectGeometry);
        Function<Change, Change> prepareChange = ConsumerUtils.consumeThenReturn(new ChangeEntitiesHandler(prepareGeometries));
        CopyChangeImporter importChange = new CopyChangeImporter(nodeRepository, wayRepository, relationRepository);
        try (BufferedInputStream changeInputStream = new BufferedInputStream(this.compression.decompress(Files.newInputStream(path, new OpenOption[0])));){
            new XmlChangeReader().stream(changeInputStream).map(prepareChange).forEach(importChange);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportOsmOsc.class.getSimpleName() + "[", "]").add("file=" + this.file).add("compression=" + this.compression).add("database=" + this.database).add("databaseSrid=" + this.databaseSrid).toString();
    }
}

