/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.features;

import java.awt.image.BufferedImage;

public class FeatureTilePointIcon {
    private final BufferedImage icon;
    private int width;
    private int height;
    private float xOffset = 0.0f;
    private float yOffset = 0.0f;

    public FeatureTilePointIcon(BufferedImage icon) {
        this(icon, icon.getWidth(), icon.getHeight());
    }

    public FeatureTilePointIcon(BufferedImage icon, int width, int height) {
        this.icon = icon;
        this.width = width;
        this.height = height;
        this.pinIcon();
    }

    public void pinIcon() {
        this.xOffset = (float)this.width / 2.0f;
        this.yOffset = this.height;
    }

    public void centerIcon() {
        this.xOffset = (float)this.width / 2.0f;
        this.yOffset = (float)this.height / 2.0f;
    }

    public BufferedImage getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.xOffset = this.xOffset / (float)this.width * (float)width;
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.yOffset = this.yOffset / (float)this.height * (float)height;
        this.height = height;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(float xOffset) {
        this.xOffset = xOffset;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(float yOffset) {
        this.yOffset = yOffset;
    }
}

