/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.Http1ResponseDecoder;
import com.linecorp.armeria.client.Http2ClientConnectionHandler;
import com.linecorp.armeria.client.Http2ClientConnectionHandlerBuilder;
import com.linecorp.armeria.client.Http2ResponseDecoder;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpSessionHandler;
import com.linecorp.armeria.client.PreTlsHandshakeException;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.SessionProtocolNegotiationCache;
import com.linecorp.armeria.client.SessionProtocolNegotiationException;
import com.linecorp.armeria.client.WebSocketHttp1ClientChannelHandler;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.internal.client.DefaultClientRequestContext;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.client.PendingExceptionUtil;
import com.linecorp.armeria.internal.client.UserAgentUtil;
import com.linecorp.armeria.internal.common.ArmeriaHttp2HeadersDecoder;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import com.linecorp.armeria.internal.common.ReadSuppressingHandler;
import com.linecorp.armeria.internal.common.TrafficLoggingHandler;
import com.linecorp.armeria.internal.common.util.ChannelUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpClientPipelineConfigurator
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientPipelineConfigurator.class);
    private static final Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.TRACE, "com.linecorp.armeria.logging.traffic.client.http2");
    private static final long UPGRADE_RESPONSE_MAX_LENGTH = 16384L;
    private static final RequestOptions REQUEST_OPTIONS_FOR_UPGRADE_REQUEST = RequestOptions.builder().responseTimeoutMillis(0L).maxResponseLength(16384L).build();
    private final HttpClientFactory clientFactory;
    private final boolean webSocket;
    @Nullable
    private final SslContext sslCtx;
    private final HttpPreference httpPreference;
    @Nullable
    private SocketAddress remoteAddress;
    private final SessionProtocol http1;
    private final SessionProtocol http2;

    HttpClientPipelineConfigurator(HttpClientFactory clientFactory, boolean webSocket, SessionProtocol sessionProtocol, @Nullable SslContext sslCtx) {
        this.clientFactory = clientFactory;
        this.webSocket = webSocket;
        if (sessionProtocol == SessionProtocol.HTTP || sessionProtocol == SessionProtocol.HTTPS) {
            this.httpPreference = HttpPreference.HTTP2_PREFERRED;
        } else if (sessionProtocol == SessionProtocol.H1 || sessionProtocol == SessionProtocol.H1C) {
            this.httpPreference = HttpPreference.HTTP1_REQUIRED;
        } else if (sessionProtocol == SessionProtocol.H2 || sessionProtocol == SessionProtocol.H2C) {
            this.httpPreference = HttpPreference.HTTP2_REQUIRED;
        } else {
            throw new Error();
        }
        if (sessionProtocol.isTls()) {
            this.sslCtx = sslCtx;
            this.http1 = SessionProtocol.H1;
            this.http2 = SessionProtocol.H2;
        } else {
            this.sslCtx = null;
            this.http1 = SessionProtocol.H1C;
            this.http2 = SessionProtocol.H2C;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise connectionPromise) throws Exception {
        this.remoteAddress = remoteAddress;
        Channel ch = ctx.channel();
        ChannelUtil.disableWriterBufferWatermark(ch);
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new FlushConsolidationHandler()});
        p.addLast(new ChannelHandler[]{ReadSuppressingAndChannelDeactivatingHandler.INSTANCE});
        try {
            if (this.isHttps()) {
                this.configureAsHttps(ch, remoteAddress);
            } else {
                this.configureAsHttp(ch, connectionPromise);
            }
        }
        catch (Throwable t) {
            connectionPromise.tryFailure(t);
            ctx.close();
            return;
        }
        finally {
            if (p.context((ChannelHandler)this) != null) {
                p.remove((ChannelHandler)this);
            }
        }
        ctx.connect(remoteAddress, localAddress, connectionPromise);
    }

    private void configureAsHttps(final Channel ch, SocketAddress remoteAddr) {
        SslHandler sslHandler;
        assert (this.isHttps());
        final ChannelPipeline p = ch.pipeline();
        if (remoteAddr instanceof InetSocketAddress) {
            InetSocketAddress raddr = (InetSocketAddress)remoteAddr;
            sslHandler = this.sslCtx.newHandler(ch.alloc(), raddr.getHostString(), raddr.getPort());
        } else {
            assert (remoteAddr instanceof DomainSocketAddress) : remoteAddr;
            sslHandler = this.sslCtx.newHandler(ch.alloc());
        }
        p.addLast(new ChannelHandler[]{HttpClientPipelineConfigurator.configureSslHandler(sslHandler)});
        p.addLast(new ChannelHandler[]{TrafficLoggingHandler.CLIENT});
        p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
            @Nullable
            private Boolean handshakeFailed;

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                SessionProtocol protocol;
                if (!(evt instanceof SslHandshakeCompletionEvent)) {
                    ctx.fireUserEventTriggered(evt);
                    return;
                }
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                this.handshakeFailed = !handshakeEvent.isSuccess();
                if (this.handshakeFailed.booleanValue()) {
                    return;
                }
                if (!sslHandler.handshakeFuture().isDone()) {
                    return;
                }
                if (HttpClientPipelineConfigurator.isHttp2Protocol(sslHandler)) {
                    if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP1_REQUIRED) {
                        HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H1, SessionProtocol.H2, "unexpected protocol negotiation result");
                        return;
                    }
                    HttpClientPipelineConfigurator.addBeforeSessionHandler(p, (ChannelHandler)HttpClientPipelineConfigurator.this.newHttp2ConnectionHandler(ch, SessionProtocol.H2));
                    protocol = SessionProtocol.H2;
                } else {
                    if (HttpClientPipelineConfigurator.this.clientFactory.useHttp2WithoutAlpn() && HttpClientPipelineConfigurator.this.attemptUpgrade()) {
                        HttpClientPipelineConfigurator.this.configureUpgradeCodec(ch, h -> HttpClientPipelineConfigurator.addBeforeSessionHandler(p, h));
                        p.remove((ChannelHandler)this);
                        return;
                    }
                    if (HttpClientPipelineConfigurator.this.httpPreference != HttpPreference.HTTP1_REQUIRED) {
                        SessionProtocolNegotiationCache.setUnsupported(HttpClientPipelineConfigurator.this.remoteAddress(ctx), SessionProtocol.H2);
                    }
                    if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                        HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2, SessionProtocol.H1, "unexpected protocol negotiation result");
                        return;
                    }
                    HttpClientPipelineConfigurator.addBeforeSessionHandler(p, (ChannelHandler)HttpClientPipelineConfigurator.newHttp1Codec(HttpClientPipelineConfigurator.this.clientFactory.http1MaxInitialLineLength(), HttpClientPipelineConfigurator.this.clientFactory.http1MaxHeaderSize(), HttpClientPipelineConfigurator.this.clientFactory.http1MaxChunkSize()));
                    protocol = SessionProtocol.H1;
                }
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, protocol);
                p.remove((ChannelHandler)this);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                if (this.handshakeFailed == null) {
                    String tlsVersion = sslHandler.engine().getSession().getProtocol();
                    PreTlsHandshakeException preTlsHandshakeException = new PreTlsHandshakeException("An unexpected exception before a TLS handshake starts. The possible reason could be one of: [connection forcefully closed by peer, unsupported TLS version, no cipher suites in common, etc.] (TLS version: " + tlsVersion + ", cipher suites: " + HttpClientPipelineConfigurator.this.sslCtx.cipherSuites() + ')', cause);
                    PendingExceptionUtil.setPendingException(ctx, (Throwable)preTlsHandshakeException);
                    return;
                }
                if (this.handshakeFailed.booleanValue() && cause instanceof DecoderException && cause.getCause() instanceof SSLException) {
                    PendingExceptionUtil.setPendingException(ctx, cause.getCause());
                    return;
                }
                Exceptions.logIfUnexpected(logger, ctx.channel(), cause);
                ctx.close();
            }
        }});
    }

    private SocketAddress remoteAddress(ChannelHandlerContext ctx) {
        return MoreObjects.firstNonNull(ctx.channel().remoteAddress(), this.remoteAddress);
    }

    private static SslHandler configureSslHandler(SslHandler sslHandler) {
        SSLEngine engine = sslHandler.engine();
        SSLParameters params = engine.getSSLParameters();
        params.setEndpointIdentificationAlgorithm("HTTPS");
        engine.setSSLParameters(params);
        return sslHandler;
    }

    private boolean attemptUpgrade() {
        switch (this.httpPreference) {
            case HTTP1_REQUIRED: {
                return false;
            }
            case HTTP2_PREFERRED: {
                assert (this.remoteAddress != null);
                return !SessionProtocolNegotiationCache.isUnsupported(this.remoteAddress, SessionProtocol.H2C);
            }
            case HTTP2_REQUIRED: {
                return true;
            }
        }
        throw new Error();
    }

    private void configureUpgradeCodec(Channel ch, Consumer<ChannelHandler> pipelineCustomizer) {
        Http2ClientConnectionHandler http2Handler = this.newHttp2ConnectionHandler(ch, this.http2);
        if (this.clientFactory.useHttp2Preface()) {
            pipelineCustomizer.accept((ChannelHandler)new DowngradeHandler());
            pipelineCustomizer.accept((ChannelHandler)http2Handler);
        } else {
            HttpClientCodec http1Codec = HttpClientPipelineConfigurator.newHttp1Codec(this.clientFactory.http1MaxInitialLineLength(), this.clientFactory.http1MaxHeaderSize(), this.clientFactory.http1MaxChunkSize());
            Http2ClientUpgradeCodec http2ClientUpgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)http2Handler);
            HttpClientUpgradeHandler http2UpgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)http1Codec, (HttpClientUpgradeHandler.UpgradeCodec)http2ClientUpgradeCodec, (int)Math.min(Integer.MAX_VALUE, 16384L));
            pipelineCustomizer.accept((ChannelHandler)http1Codec);
            pipelineCustomizer.accept((ChannelHandler)new WorkaroundHandler());
            pipelineCustomizer.accept((ChannelHandler)http2UpgradeHandler);
            pipelineCustomizer.accept((ChannelHandler)new UpgradeRequestHandler(http2Handler.responseDecoder()));
        }
    }

    private void configureAsHttp(Channel ch, ChannelPromise connectionPromise) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{TrafficLoggingHandler.CLIENT});
        if (this.attemptUpgrade()) {
            this.configureUpgradeCodec(ch, xva$0 -> pipeline.addLast(new ChannelHandler[]{xva$0}));
        } else {
            pipeline.addLast(new ChannelHandler[]{HttpClientPipelineConfigurator.newHttp1Codec(this.clientFactory.http1MaxInitialLineLength(), this.clientFactory.http1MaxHeaderSize(), this.clientFactory.http1MaxChunkSize())});
            connectionPromise.addListener(future -> {
                if (future.isSuccess()) {
                    this.finishSuccessfully(pipeline, SessionProtocol.H1C);
                }
            });
        }
    }

    void finishSuccessfully(ChannelPipeline pipeline, SessionProtocol protocol) {
        int initialWindow;
        if (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C) {
            HttpClientPipelineConfigurator.addBeforeSessionHandler(pipeline, (ChannelHandler)(this.webSocket ? new WebSocketHttp1ClientChannelHandler(pipeline.channel()) : new Http1ResponseDecoder(pipeline.channel(), this.clientFactory, protocol)));
        } else if ((protocol == SessionProtocol.H2 || protocol == SessionProtocol.H2C) && (initialWindow = this.clientFactory.http2InitialConnectionWindowSize()) > 65535) {
            HttpClientPipelineConfigurator.incrementLocalWindowSize(pipeline, initialWindow - 65535);
        }
        pipeline.fireUserEventTriggered((Object)protocol);
    }

    private static void incrementLocalWindowSize(ChannelPipeline pipeline, int delta) {
        try {
            Http2Connection connection = ((Http2ClientConnectionHandler)pipeline.get(Http2ClientConnectionHandler.class)).connection();
            ((Http2LocalFlowController)connection.local().flowController()).incrementWindowSize(connection.connectionStream(), delta);
        }
        catch (Http2Exception e) {
            logger.warn("Failed to increment local flowController window size: {}", (Object)delta, (Object)e);
        }
    }

    private static void addBeforeSessionHandler(ChannelPipeline pipeline, ChannelHandler handler) {
        ChannelHandlerContext lastContext = pipeline.lastContext();
        if (lastContext.handler().getClass() == HttpSessionHandler.class) {
            pipeline.addBefore(lastContext.name(), null, handler);
        } else {
            pipeline.addLast(new ChannelHandler[]{handler});
        }
    }

    void finishWithNegotiationFailure(ChannelHandlerContext ctx, SessionProtocol expected, SessionProtocol actual, String reason) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.channel().eventLoop().execute(() -> pipeline.fireUserEventTriggered((Object)new SessionProtocolNegotiationException(expected, actual, reason)));
        ctx.close();
    }

    private boolean isHttps() {
        return this.sslCtx != null;
    }

    private static boolean isHttp2Protocol(SslHandler sslHandler) {
        return "h2".equals(sslHandler.applicationProtocol());
    }

    static void retryWith(ChannelHandlerContext ctx, SessionProtocol protocol) {
        HttpSession.get(ctx.channel()).retryWith(protocol);
        ctx.close();
    }

    private Http2ClientConnectionHandler newHttp2ConnectionHandler(Channel ch, SessionProtocol protocol) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        Http2ConnectionEncoder encoder = HttpClientPipelineConfigurator.encoder((Http2Connection)connection);
        Http2ConnectionDecoder decoder = this.decoder((Http2Connection)connection, encoder);
        Http2ClientConnectionHandlerBuilder builder = new Http2ClientConnectionHandlerBuilder(ch, this.clientFactory, protocol);
        ((Http2ClientConnectionHandlerBuilder)builder.codec(decoder, encoder)).initialSettings(this.http2Settings());
        long timeout = this.clientFactory.idleTimeoutMillis();
        if (timeout > 0L) {
            builder.gracefulShutdownTimeoutMillis(timeout);
        } else {
            builder.gracefulShutdownTimeoutMillis(-1L);
        }
        return (Http2ClientConnectionHandler)builder.build();
    }

    private static Http2ConnectionEncoder encoder(Http2Connection connection) {
        DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter();
        writer = new Http2OutboundFrameLogger((Http2FrameWriter)writer, frameLogger);
        return new DefaultHttp2ConnectionEncoder(connection, (Http2FrameWriter)writer);
    }

    private Http2ConnectionDecoder decoder(Http2Connection connection, Http2ConnectionEncoder encoder) {
        ArmeriaHttp2HeadersDecoder headersDecoder = new ArmeriaHttp2HeadersDecoder(false, this.clientFactory.http2MaxHeaderListSize());
        DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader((Http2HeadersDecoder)headersDecoder);
        reader = new Http2InboundFrameLogger((Http2FrameReader)reader, frameLogger);
        return new DefaultHttp2ConnectionDecoder(connection, encoder, (Http2FrameReader)reader);
    }

    private Http2Settings http2Settings() {
        int maxFrameSize;
        Http2Settings settings = new Http2Settings();
        int initialWindowSize = this.clientFactory.http2InitialStreamWindowSize();
        if (initialWindowSize != 65535) {
            settings.initialWindowSize(initialWindowSize);
        }
        if ((maxFrameSize = this.clientFactory.http2MaxFrameSize()) != 16384) {
            settings.maxFrameSize(maxFrameSize);
        }
        settings.maxHeaderListSize(this.clientFactory.http2MaxHeaderListSize());
        settings.pushEnabled(false);
        return settings;
    }

    private static HttpClientCodec newHttp1Codec(int defaultMaxInitialLineLength, int defaultMaxHeaderSize, int defaultMaxChunkSize) {
        return new HttpClientCodec(defaultMaxInitialLineLength, defaultMaxHeaderSize, defaultMaxChunkSize);
    }

    private static enum HttpPreference {
        HTTP1_REQUIRED,
        HTTP2_PREFERRED,
        HTTP2_REQUIRED;

    }

    private static final class ReadSuppressingAndChannelDeactivatingHandler
    extends ReadSuppressingHandler {
        private static final ReadSuppressingAndChannelDeactivatingHandler INSTANCE = new ReadSuppressingAndChannelDeactivatingHandler();

        private ReadSuppressingAndChannelDeactivatingHandler() {
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            HttpSession.get(ctx.channel()).deactivate();
            super.close(ctx, promise);
        }
    }

    private final class DowngradeHandler
    extends ByteToMessageDecoder {
        private boolean handledResponse;

        private DowngradeHandler() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() < 9) {
                return;
            }
            this.handledResponse = true;
            ChannelPipeline p = ctx.pipeline();
            if (!this.isSettingsFrame(in)) {
                SessionProtocolNegotiationCache.setUnsupported(HttpClientPipelineConfigurator.this.remoteAddress(ctx), HttpClientPipelineConfigurator.this.http2);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, HttpClientPipelineConfigurator.this.http2, HttpClientPipelineConfigurator.this.http1, "received a non-HTTP/2 response for the HTTP/2 connection preface");
                } else {
                    HttpClientPipelineConfigurator.retryWith(ctx, HttpClientPipelineConfigurator.this.http1);
                }
                in.skipBytes(in.readableBytes());
            } else {
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, HttpClientPipelineConfigurator.this.http2);
            }
            p.remove((ChannelHandler)this);
        }

        private boolean isSettingsFrame(ByteBuf in) {
            int start = in.readerIndex();
            return in.getByte(start + 3) == 4 && (in.getInt(start + 5) & Integer.MAX_VALUE) == 0;
        }

        protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            super.decodeLast(ctx, in, out);
            if (!this.handledResponse) {
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, HttpClientPipelineConfigurator.this.http2, HttpClientPipelineConfigurator.this.http1, "too little data to determine the HTTP version");
                } else {
                    HttpClientPipelineConfigurator.retryWith(ctx, HttpClientPipelineConfigurator.this.http1);
                }
            }
        }
    }

    private static final class WorkaroundHandler
    extends ChannelDuplexHandler {
        private static final AsciiString CONNECTION_VALUE = AsciiString.cached((String)"HTTP2-Settings,Upgrade");
        private boolean needsToFilterUpgradeResponse = true;
        private boolean needsToFilterUpgradeRequest = true;

        private WorkaroundHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (this.needsToFilterUpgradeResponse && msg instanceof HttpResponse) {
                HttpHeaders headers;
                this.needsToFilterUpgradeResponse = false;
                HttpResponse res = (HttpResponse)msg;
                if (res.status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && !(headers = res.headers()).contains((CharSequence)HttpHeaderNames.UPGRADE)) {
                    headers.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
                }
                if (!this.needsToFilterUpgradeRequest) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
            ctx.fireChannelRead(msg);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (this.needsToFilterUpgradeRequest) {
                this.needsToFilterUpgradeRequest = false;
                FullHttpRequest req = (FullHttpRequest)msg;
                req.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)CONNECTION_VALUE);
                if (!this.needsToFilterUpgradeResponse) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
            super.write(ctx, msg, promise);
        }
    }

    private final class UpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private final Http2ResponseDecoder responseDecoder;
        @Nullable
        private HttpClientUpgradeHandler.UpgradeEvent upgradeEvt;
        private String upgradeRejectionCause = "";
        private boolean needsToClose;

        UpgradeRequestHandler(Http2ResponseDecoder responseDecoder) {
            this.responseDecoder = responseDecoder;
        }

        public void channelActive(final ChannelHandlerContext ctx) throws Exception {
            String host;
            DefaultFullHttpRequest upgradeReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.OPTIONS, "*");
            assert (HttpClientPipelineConfigurator.this.remoteAddress != null);
            if (HttpClientPipelineConfigurator.this.remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress raddr = (InetSocketAddress)HttpClientPipelineConfigurator.this.remoteAddress;
                host = ArmeriaHttpUtil.authorityHeader(raddr.getHostString(), raddr.getPort(), (HttpClientPipelineConfigurator.this.isHttps() ? SessionProtocol.H1 : SessionProtocol.H1C).defaultPort());
            } else {
                assert (HttpClientPipelineConfigurator.this.remoteAddress instanceof DomainSocketAddress) : HttpClientPipelineConfigurator.access$1400(HttpClientPipelineConfigurator.this);
                host = SystemInfo.hostname();
            }
            upgradeReq.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host);
            upgradeReq.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)UserAgentUtil.USER_AGENT);
            ctx.writeAndFlush((Object)upgradeReq);
            Http2ResponseDecoder responseDecoder = this.responseDecoder;
            DecodedHttpResponse res = new DecodedHttpResponse(ctx.channel().eventLoop());
            res.init(responseDecoder.inboundTrafficController());
            res.subscribe(new Subscriber<HttpObject>(){
                private boolean notified;

                public void onSubscribe(Subscription s) {
                    s.request(Long.MAX_VALUE);
                }

                public void onNext(HttpObject o) {
                    if (this.notified) {
                        return;
                    }
                    this.notified = true;
                    assert (UpgradeRequestHandler.this.upgradeEvt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL);
                    UpgradeRequestHandler.this.onUpgradeResponse(ctx, true);
                }

                public void onError(Throwable t) {
                    ctx.fireExceptionCaught(t);
                }

                public void onComplete() {
                }
            }, (EventExecutor)ctx.channel().eventLoop());
            responseDecoder.reserveUnfinishedResponse(Integer.MAX_VALUE);
            DefaultClientRequestContext reqCtx = new DefaultClientRequestContext(ctx.channel().eventLoop(), Flags.meterRegistry(), SessionProtocol.H1C, RequestId.random(), com.linecorp.armeria.common.HttpMethod.OPTIONS, RequestTarget.forClient("*"), ClientOptions.of(), HttpRequest.of(com.linecorp.armeria.common.HttpMethod.OPTIONS, "*"), null, REQUEST_OPTIONS_FOR_UPGRADE_REQUEST, CancellationScheduler.noop(), System.nanoTime(), SystemInfo.currentTimeMicros());
            responseDecoder.addResponse(0, res, reqCtx, ctx.channel().eventLoop());
            ctx.fireChannelActive();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (!(evt instanceof HttpClientUpgradeHandler.UpgradeEvent)) {
                ctx.fireUserEventTriggered(evt);
                return;
            }
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvt = (HttpClientUpgradeHandler.UpgradeEvent)evt;
            if (upgradeEvt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED) {
                return;
            }
            this.upgradeEvt = upgradeEvt;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof HttpResponse) {
                assert (this.upgradeEvt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED);
                HttpResponse res = (HttpResponse)msg;
                this.upgradeRejectionCause = "Upgrade request rejected with: " + res;
                boolean bl = this.needsToClose = !HttpUtil.isKeepAlive((HttpMessage)res) || !HttpUtil.isContentLengthSet((HttpMessage)res) && !HttpUtil.isTransferEncodingChunked((HttpMessage)res);
                if (this.needsToClose) {
                    this.onUpgradeResponse(ctx, false);
                }
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (this.needsToClose) {
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (msg instanceof HttpContent) {
                if (msg instanceof LastHttpContent) {
                    this.onUpgradeResponse(ctx, false);
                }
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            ctx.fireChannelRead(msg);
        }

        private void onUpgradeResponse(ChannelHandlerContext ctx, boolean success) {
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvt = this.upgradeEvt;
            assert (upgradeEvt != null) : "received an upgrade response before an UpgradeEvent";
            ChannelPipeline p = ctx.pipeline();
            p.remove((ChannelHandler)this);
            if (this.needsToClose) {
                SessionProtocolNegotiationCache.setUnsupported(HttpClientPipelineConfigurator.this.remoteAddress(ctx), HttpClientPipelineConfigurator.this.http2);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, HttpClientPipelineConfigurator.this.http2, HttpClientPipelineConfigurator.this.http1, this.upgradeRejectionCause);
                } else {
                    HttpClientPipelineConfigurator.retryWith(ctx, HttpClientPipelineConfigurator.this.http1);
                }
                return;
            }
            if (success) {
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, HttpClientPipelineConfigurator.this.http2);
            } else {
                SessionProtocolNegotiationCache.setUnsupported(HttpClientPipelineConfigurator.this.remoteAddress(ctx), HttpClientPipelineConfigurator.this.http2);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, HttpClientPipelineConfigurator.this.http2, HttpClientPipelineConfigurator.this.http1, this.upgradeRejectionCause);
                    return;
                }
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, HttpClientPipelineConfigurator.this.http1);
            }
        }
    }
}

