/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.AbstractEndpointSelector;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class RoundRobinStrategy
implements EndpointSelectionStrategy {
    static final RoundRobinStrategy INSTANCE = new RoundRobinStrategy();

    private RoundRobinStrategy() {
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new RoundRobinSelector(endpointGroup);
    }

    static class RoundRobinSelector
    extends AbstractEndpointSelector {
        private final AtomicInteger sequence = new AtomicInteger();

        RoundRobinSelector(EndpointGroup endpointGroup) {
            super(endpointGroup);
            this.initialize();
        }

        @Override
        public Endpoint selectNow(ClientRequestContext ctx) {
            List<Endpoint> endpoints = this.group().endpoints();
            if (endpoints.isEmpty()) {
                return null;
            }
            int currentSequence = this.sequence.getAndIncrement();
            return endpoints.get(Math.abs(currentSequence % endpoints.size()));
        }
    }
}

