/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.metric;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.internal.common.metric.RequestMetricSupport;
import com.linecorp.armeria.internal.server.RouteDecoratingService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.TransientServiceOption;
import com.linecorp.armeria.server.metric.MetricCollectingServiceBuilder;
import io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;
import java.util.function.Function;

public final class MetricCollectingService
extends SimpleDecoratingHttpService {
    private static final AttributeKey<Boolean> REQUEST_METRICS_SET = AttributeKey.valueOf(MetricCollectingService.class, (String)"REQUEST_METRICS_SET");
    private final MeterIdPrefixFunction meterIdPrefixFunction;
    @Nullable
    private final BiPredicate<? super RequestContext, ? super RequestLog> successFunction;
    private final ConcurrentMap<Route, Boolean> routeCache = new ConcurrentHashMap<Route, Boolean>();

    public static Function<? super HttpService, MetricCollectingService> newDecorator(MeterIdPrefixFunction meterIdPrefixFunction) {
        Objects.requireNonNull(meterIdPrefixFunction, "meterIdPrefixFunction");
        return MetricCollectingService.builder(meterIdPrefixFunction).newDecorator();
    }

    public static MetricCollectingServiceBuilder builder(MeterIdPrefixFunction meterIdPrefixFunction) {
        return new MetricCollectingServiceBuilder(meterIdPrefixFunction);
    }

    MetricCollectingService(HttpService delegate, MeterIdPrefixFunction meterIdPrefixFunction, @Nullable BiPredicate<? super RequestContext, ? super RequestLog> successFunction) {
        super(delegate);
        this.meterIdPrefixFunction = Objects.requireNonNull(meterIdPrefixFunction, "meterIdPrefixFunction");
        this.successFunction = successFunction;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if (this.shouldRecordMetrics(ctx)) {
            RequestMetricSupport.setup(ctx, REQUEST_METRICS_SET, this.meterIdPrefixFunction, true, this.successFunction != null ? this.successFunction::test : ctx.config().successFunction());
        }
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
    }

    private boolean shouldRecordMetrics(ServiceRequestContext ctx) {
        if (!ctx.config().transientServiceOptions().contains((Object)TransientServiceOption.WITH_METRIC_COLLECTION)) {
            return false;
        }
        Route route = ctx.config().route();
        Boolean cachedResult = (Boolean)this.routeCache.get(route);
        if (cachedResult != null) {
            return cachedResult;
        }
        Service delegate = (Service)this.unwrap();
        boolean shouldRecord = delegate instanceof RouteDecoratingService ? ((RouteDecoratingService)delegate).as(ctx, MetricCollectingService.class) == null : delegate.as(MetricCollectingService.class) == null;
        this.routeCache.put(route, shouldRecord);
        return shouldRecord;
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        super.serviceAdded(cfg);
        this.routeCache.clear();
    }
}

