/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import mil.nga.sf.geojson.Geometry;
import mil.nga.sf.geojson.GeometryType;
import mil.nga.sf.geojson.Position;

public class Point
extends Geometry {
    private static final long serialVersionUID = 2L;
    private Position position;

    public static Point fromCoordinates(Position coordinates) {
        return new Point(coordinates);
    }

    public Point() {
    }

    public Point(Position position) {
        this.position = position;
    }

    public Point(mil.nga.sf.Point point) {
        this.setPoint(point);
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.POINT;
    }

    @Override
    public mil.nga.sf.Geometry getGeometry() {
        return this.getPoint();
    }

    public Position getCoordinates() {
        return this.getPosition();
    }

    public void setCoordinates(Position coordinates) {
        this.setPosition(coordinates);
    }

    @JsonIgnore
    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @JsonIgnore
    public mil.nga.sf.Point getPoint() {
        return this.position.toSimplePoint();
    }

    public void setPoint(mil.nga.sf.Point point) {
        this.position = new Position(point);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        return !(this.position == null ? other.position != null : !this.position.equals(other.position));
    }
}

