/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;

@GenerateInline
@GenerateUncached
@ImportStatic(value={JSConfig.class})
public abstract class JSToBooleanNode
extends JavaScriptBaseNode {
    protected JSToBooleanNode() {
    }

    public final boolean executeBoolean(Object value) {
        return this.executeBoolean(null, value);
    }

    public abstract boolean executeBoolean(Node var1, Object var2);

    @NeverDefault
    public static JSToBooleanNode create() {
        return JSToBooleanNodeGen.create();
    }

    @NeverDefault
    public static JSToBooleanNode getUncached() {
        return JSToBooleanNodeGen.getUncached();
    }

    @Specialization
    protected static boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static boolean doNull(Object value) {
        return false;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static boolean doUndefined(Object value) {
        return false;
    }

    @Specialization
    protected static boolean doInt(int value) {
        return value != 0;
    }

    @Specialization
    protected static boolean doLong(long value) {
        return value != 0L;
    }

    @Specialization
    protected static boolean doDouble(double value) {
        return value != 0.0 && !Double.isNaN(value);
    }

    @Specialization
    protected static boolean doBigInt(BigInt value) {
        return value.compareTo(BigInt.ZERO) != 0;
    }

    @Specialization
    protected static boolean doString(TruffleString value) {
        return Strings.length(value) != 0;
    }

    @Specialization
    protected static boolean doJSObject(JSObject value) {
        return true;
    }

    @Specialization
    protected static boolean doSymbol(Symbol value) {
        return true;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(value)"}, limit="InteropLibraryLimit")
    protected final boolean doForeignObject(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
        if (interop.isNull(value)) {
            return false;
        }
        try {
            if (interop.isBoolean(value)) {
                return interop.asBoolean(value);
            }
            if (interop.isString(value)) {
                return !Strings.isEmpty(interop.asTruffleString(value));
            }
            if (interop.isNumber(value)) {
                if (interop.fitsInInt(value)) {
                    return JSToBooleanNode.doInt(interop.asInt(value));
                }
                if (interop.fitsInDouble(value)) {
                    return JSToBooleanNode.doDouble(interop.asDouble(value));
                }
                return true;
            }
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(value, (InteropException)((Object)e), this);
        }
        return true;
    }
}

