/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Classes;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

final class GridExtentCRS {
    private static final String NAME_PARAM = "Target grid name";
    private static final String ANCHOR_PARAM = "Pixel in cell";
    private static final OperationMethod METHOD;
    private static final InternationalString SCOPE;
    private static final NamedIdentifier CS_NAME;

    private GridExtentCRS() {
    }

    static DerivedCRS forCoverage(String name, GridGeometry gg, PixelInCell anchor, Locale locale) throws FactoryException, NoninvertibleTransformException {
        CoordinateSystem cs;
        CoordinateReferenceSystem crs = gg.getCoordinateReferenceSystem();
        boolean reduce = false;
        while (!(crs instanceof SingleCRS)) {
            if (!(crs instanceof CompoundCRS)) {
                throw GridExtentCRS.unsupported(locale, crs);
            }
            crs = (CoordinateReferenceSystem)((CompoundCRS)crs).getComponents().get(0);
            reduce = true;
        }
        MathTransform gridToCRS = gg.getGridToCRS(anchor);
        DimensionNameType[] types = gg.getExtent().getAxisTypes();
        if (reduce) {
            TransformSeparator s = new TransformSeparator(gridToCRS);
            s.addTargetDimensionRange(0, crs.getCoordinateSystem().getDimension());
            gridToCRS = s.separate();
            int[] src = s.getSourceDimensions();
            DimensionNameType[] allTypes = types;
            types = new DimensionNameType[src.length];
            for (int i = 0; i < src.length; ++i) {
                int j = src[i];
                if (j >= allTypes.length) continue;
                types[i] = allTypes[j];
            }
        }
        if ((cs = GridExtentCRS.createCS(gridToCRS.getSourceDimensions(), null, types, locale)) == null) {
            throw GridExtentCRS.unsupported(locale, crs);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(8);
        properties.put("name", METHOD.getName());
        properties.put("locale", locale);
        properties.put("scope", SCOPE);
        gg.getGeographicExtent().ifPresent(domain -> properties.put("domainOfValidity", new DefaultExtent(null, (GeographicExtent)domain, null, null)));
        ParameterValueGroup params = METHOD.getParameters().createValue();
        params.parameter(NAME_PARAM).setValue((Object)name);
        params.parameter(ANCHOR_PARAM).setValue((Object)anchor);
        DefaultConversion conversion = new DefaultConversion(properties, METHOD, gridToCRS.inverse(), params);
        properties.put("name", name);
        return DefaultDerivedCRS.create(properties, (SingleCRS)((SingleCRS)crs), (Conversion)conversion, (CoordinateSystem)cs);
    }

    private static FactoryException unsupported(Locale locale, CoordinateReferenceSystem crs) {
        return new FactoryException(Errors.getResources((Locale)locale).getString((short)163, (Object)Classes.getShortClassName((Object)crs)));
    }

    private static Map<String, ?> properties(Object name) {
        return Map.of("name", name);
    }

    private static CoordinateSystemAxis axis(CSFactory csFactory, String name, String abbreviation, AxisDirection direction) throws FactoryException {
        return csFactory.createCoordinateSystemAxis(GridExtentCRS.properties(name), abbreviation, direction, Units.UNITY);
    }

    private static String abbreviation(int dimension) {
        StringBuilder b = new StringBuilder(4).append('x').append(dimension);
        int i = b.length();
        while (--i >= 1) {
            b.setCharAt(i, Characters.toSuperScript((char)b.charAt(i)));
        }
        return b.toString();
    }

    private static CoordinateSystem createCS(int tgtDim, Matrix gridToCRS, DimensionNameType[] types, Locale locale) throws FactoryException {
        AbstractCS cs;
        int srcDim = types.length;
        if (gridToCRS != null) {
            srcDim = Math.min(gridToCRS.getNumCol() - 1, srcDim);
        }
        CoordinateSystemAxis[] axes = new CoordinateSystemAxis[tgtDim];
        GeodeticObjectFactory csFactory = GeodeticObjectFactory.provider();
        boolean hasVertical = false;
        boolean hasTime = false;
        boolean hasOther = false;
        for (int i = 0; i < srcDim; ++i) {
            AxisDirection direction;
            String abbreviation;
            DimensionNameType type = types[i];
            if (type == null) continue;
            int target = i;
            double scale = 0.0;
            if (gridToCRS != null) {
                target = -1;
                for (int j = 0; j < tgtDim; ++j) {
                    double m = gridToCRS.getElement(j, i);
                    if (m == 0.0) continue;
                    if (target >= 0 || axes[j] != null || Math.abs(m) != 1.0) {
                        return null;
                    }
                    target = j;
                    scale = m;
                }
                if (target < 0) {
                    return null;
                }
            }
            if (type == DimensionNameType.COLUMN || type == DimensionNameType.SAMPLE) {
                abbreviation = "x";
                direction = AxisDirection.COLUMN_POSITIVE;
            } else if (type == DimensionNameType.ROW || type == DimensionNameType.LINE) {
                abbreviation = "y";
                direction = AxisDirection.ROW_POSITIVE;
            } else if (type == DimensionNameType.VERTICAL) {
                abbreviation = "z";
                direction = AxisDirection.UP;
                hasVertical = true;
            } else if (type == DimensionNameType.TIME) {
                abbreviation = "t";
                direction = AxisDirection.FUTURE;
                hasTime = true;
            } else {
                abbreviation = GridExtentCRS.abbreviation(target);
                direction = AxisDirection.OTHER;
                hasOther = true;
            }
            int k = tgtDim;
            while (--k >= 0) {
                CoordinateSystemAxis previous = axes[k];
                if (previous == null) continue;
                if (direction.equals((Object)AxisDirections.absolute((AxisDirection)previous.getDirection()))) {
                    direction = AxisDirection.OTHER;
                    hasOther = true;
                }
                if (!abbreviation.equals(previous.getAbbreviation())) continue;
                abbreviation = GridExtentCRS.abbreviation(target);
            }
            if (scale < 0.0) {
                direction = AxisDirections.opposite((AxisDirection)direction);
            }
            String name = Types.toString((InternationalString)Types.getCodeTitle((CodeList)type), (Locale)locale);
            axes[target] = GridExtentCRS.axis((CSFactory)csFactory, name, abbreviation, direction);
        }
        for (int j = 0; j < tgtDim; ++j) {
            if (axes[j] != null) continue;
            String name = Vocabulary.getResources((Locale)locale).getString((short)64, (Object)j);
            String abbreviation = GridExtentCRS.abbreviation(j);
            axes[j] = GridExtentCRS.axis((CSFactory)csFactory, name, abbreviation, AxisDirection.OTHER);
        }
        Map<String, ?> properties = GridExtentCRS.properties(CS_NAME);
        if (hasOther || tgtDim > (hasTime ? 1 : 3)) {
            cs = new AbstractCS(properties, axes);
        } else {
            switch (tgtDim) {
                case 1: {
                    CoordinateSystemAxis axis = axes[0];
                    if (hasVertical) {
                        cs = csFactory.createVerticalCS(properties, axis);
                        break;
                    }
                    if (hasTime) {
                        cs = csFactory.createTimeCS(properties, axis);
                        break;
                    }
                    cs = csFactory.createLinearCS(properties, axis);
                    break;
                }
                case 2: {
                    cs = gridToCRS == null ? csFactory.createCartesianCS(properties, axes[0], axes[1]) : csFactory.createAffineCS(properties, axes[0], axes[1]);
                    break;
                }
                case 3: {
                    cs = gridToCRS == null ? csFactory.createCartesianCS(properties, axes[0], axes[1], axes[2]) : csFactory.createAffineCS(properties, axes[0], axes[1], axes[2]);
                    break;
                }
                default: {
                    cs = null;
                }
            }
        }
        return cs;
    }

    static EngineeringCRS forExtentAlone(Matrix gridToCRS, DimensionNameType[] types) throws FactoryException {
        CoordinateSystem cs = GridExtentCRS.createCS(gridToCRS.getNumRow() - 1, gridToCRS, types, null);
        if (cs == null) {
            return null;
        }
        return GeodeticObjectFactory.provider().createEngineeringCRS(GridExtentCRS.properties(cs.getName()), CommonCRS.Engineering.GRID.datum(), cs);
    }

    static {
        ParameterBuilder b = new ParameterBuilder().setRequired(true);
        ParameterDescriptor name = ((ParameterBuilder)b.addName((CharSequence)NAME_PARAM)).create(String.class, null);
        ParameterDescriptor anchor = ((ParameterBuilder)b.addName((CharSequence)ANCHOR_PARAM)).create(PixelInCell.class, (Object)PixelInCell.CELL_CENTER);
        ParameterDescriptorGroup params = ((ParameterBuilder)b.addName((CharSequence)"CRS to grid indices")).createGroup(new GeneralParameterDescriptor[]{name, anchor});
        METHOD = new DefaultOperationMethod(GridExtentCRS.properties(params.getName()), params);
        SCOPE = Resources.formatInternational((short)79, new Object[0]);
        CS_NAME = new NamedIdentifier(Citations.SIS, (CharSequence)Vocabulary.formatInternational((short)97));
    }
}

