/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;
import org.apache.sis.coverage.grid.j2d.ColorModelFactory;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.coverage.grid.j2d.ObservableImage;
import org.apache.sis.coverage.grid.j2d.TileOpExecutor;
import org.apache.sis.image.BandAggregateImage;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.SourceAlignedImage;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

class BandSelectImage
extends SourceAlignedImage {
    private static final Set<String> INHERITED_PROPERTIES = Set.of("org.apache.sis.GridGeometry", "org.apache.sis.PositionalAccuracy", "org.apache.sis.SampleDimensions", "org.apache.sis.SampleResolutions", "org.apache.sis.Statistics");
    private static final Set<String> REDUCED_PROPERTIES = Set.of("org.apache.sis.SampleDimensions", "org.apache.sis.SampleResolutions", "org.apache.sis.Statistics");
    private final int[] bands;

    private BandSelectImage(RenderedImage source, ColorModel cm, int[] bands) {
        super(source, cm, source.getSampleModel().createSubsetSampleModel(bands));
        this.bands = bands;
        this.ensureCompatible(cm);
    }

    final int[] getSourceBands(int[] subset) {
        int[] select = new int[subset.length];
        for (int i = 0; i < subset.length; ++i) {
            select[i] = this.bands[subset[i]];
        }
        return Arrays.equals(subset, select) ? subset : select;
    }

    static RenderedImage create(RenderedImage source, boolean unwrap, int ... bands) {
        RenderedImage image;
        int numBands = ImageUtilities.getNumBands(source);
        if (bands.length == numBands && ArraysExt.isRange((int)0, (int[])bands)) {
            return source;
        }
        ArgumentChecks.ensureNonEmptyBounded((String)"bands", (boolean)false, (int)0, (int)(numBands - 1), (int[])bands);
        ColorModel cm = ColorModelFactory.createSubset(source.getColorModel(), bands);
        if (source instanceof RecoloredImage) {
            source = ((RecoloredImage)source).source;
        }
        if (source instanceof BandSelectImage) {
            BandSelectImage select = (BandSelectImage)source;
            bands = select.getSourceBands(bands);
            source = select.getSource();
        }
        if (unwrap && source instanceof BandAggregateImage) {
            return ((BandAggregateImage)source).subset(bands, cm, null);
        }
        if (cm != null && source instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)source;
            Hashtable<String, Object> properties = new Hashtable<String, Object>(8);
            for (String key : INHERITED_PROPERTIES) {
                Object value = BandSelectImage.getProperty(bi, key, bands);
                if (value == Image.UndefinedProperty) continue;
                properties.put(key, value);
            }
            image = new ObservableImage(cm, bi.getRaster().createWritableChild(0, 0, bi.getWidth(), bi.getHeight(), 0, 0, bands), bi.isAlphaPremultiplied(), properties);
        } else {
            image = source instanceof WritableRenderedImage ? new Writable(source, cm, bands) : new BandSelectImage(source, cm, bands);
        }
        return ImageProcessor.unique(image);
    }

    @Override
    public String[] getPropertyNames() {
        return BandSelectImage.filterPropertyNames(this.getSource().getPropertyNames(), INHERITED_PROPERTIES, null);
    }

    @Override
    public Object getProperty(String key) {
        if (INHERITED_PROPERTIES.contains(key)) {
            return BandSelectImage.getProperty(this.getSource(), key, this.bands);
        }
        return super.getProperty(key);
    }

    private static Object getProperty(RenderedImage source, String key, int[] bands) {
        Class<?> componentType;
        Object value = source.getProperty(key);
        if (value != null && REDUCED_PROPERTIES.contains(key) && (componentType = value.getClass().getComponentType()) != null) {
            Object reduced = Array.newInstance(componentType, bands.length);
            for (int i = 0; i < bands.length; ++i) {
                Array.set(reduced, i, Array.get(value, bands[i]));
            }
            return reduced;
        }
        return value;
    }

    @Override
    protected Raster computeTile(int tileX, int tileY, WritableRaster previous) {
        Raster parent = this.getSource().getTile(tileX, tileY);
        int x = parent.getMinX();
        int y = parent.getMinY();
        return parent.createChild(x, y, parent.getWidth(), parent.getHeight(), x, y, this.bands);
    }

    final WritableRaster apply(WritableRaster parent) {
        int x = parent.getMinX();
        int y = parent.getMinY();
        return parent.createWritableChild(x, y, parent.getWidth(), parent.getHeight(), x, y, this.bands);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 97 * Arrays.hashCode(this.bands);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            BandSelectImage other = (BandSelectImage)object;
            return Arrays.equals(this.bands, other.bands);
        }
        return false;
    }

    private static final class Writable
    extends BandSelectImage
    implements WritableRenderedImage {
        Writable(RenderedImage source, ColorModel cm, int[] bands) {
            super(source, cm, bands);
        }

        private WritableRenderedImage target() {
            return (WritableRenderedImage)this.getSource();
        }

        @Override
        public WritableRaster getWritableTile(int tileX, int tileY) {
            this.markTileWritable(tileX, tileY, true);
            WritableRaster parent = this.target().getWritableTile(tileX, tileY);
            return this.apply(parent);
        }

        @Override
        public void releaseWritableTile(int tileX, int tileY) {
            this.target().releaseWritableTile(tileX, tileY);
            this.markTileWritable(tileX, tileY, false);
        }

        @Override
        public void addTileObserver(TileObserver observer) {
            this.target().addTileObserver(observer);
        }

        @Override
        public void removeTileObserver(TileObserver observer) {
            this.target().removeTileObserver(observer);
        }

        @Override
        public void setData(final Raster data) {
            WritableRenderedImage target = this.target();
            TileOpExecutor executor = new TileOpExecutor(target, data.getBounds()){

                @Override
                protected void writeTo(WritableRaster tile) {
                    this.apply(tile).setRect(data);
                }
            };
            executor.writeTo(target);
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }
    }
}

