/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.data.type.DataType;

public class BooleanListDataType
implements DataType<List<Boolean>> {
    @Override
    public int size(List<Boolean> values) {
        return 4 + values.size() * 1;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Boolean> values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (boolean value : values) {
            buffer.put(p, (byte)(value ? 1 : 0));
            ++p;
        }
    }

    @Override
    public List<Boolean> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 1;
        ArrayList<Boolean> values = new ArrayList<Boolean>(length);
        for (int index = 0; index < length; ++index) {
            values.add(buffer.get(position + 4 + index * 1) == 1);
        }
        return values;
    }
}

