/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.data.type.FixedSizeDataType;

public class SmallLongDataType
extends FixedSizeDataType<Long> {
    private final int n;

    public SmallLongDataType(int n) {
        super(n);
        if (n < 1 || n > 8) {
            throw new IllegalArgumentException("The number of bytes used to store small longs must be comprised between 1 and 8");
        }
        this.n = n;
    }

    @Override
    public int size(Long value) {
        return this.n;
    }

    @Override
    public void write(ByteBuffer buffer, int position, Long value) {
        for (int i = 0; i < this.n; ++i) {
            buffer.put(position + i, (byte)(value >> (i << 3)));
        }
    }

    @Override
    public Long read(ByteBuffer buffer, int position) {
        int i;
        byte s = (byte)(buffer.get(position + this.n - 1) >= 0 ? 0 : -1);
        long l = 0L;
        for (i = 7; i > this.n - 1; --i) {
            l |= ((long)s & 0xFFL) << (i << 3);
        }
        for (i = this.n - 1; i >= 0; --i) {
            l |= ((long)buffer.get(position + i) & 0xFFL) << (i << 3);
        }
        return l;
    }
}

