/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.pbf;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.baremaps.openstreetmap.function.BlobToBlockMapper;
import org.apache.baremaps.openstreetmap.function.BlockEntitiesHandler;
import org.apache.baremaps.openstreetmap.function.CoordinateMapBuilder;
import org.apache.baremaps.openstreetmap.function.EntityGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.EntityProjectionTransformer;
import org.apache.baremaps.openstreetmap.function.ReferenceMapBuilder;
import org.apache.baremaps.openstreetmap.model.Block;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.pbf.BlobIterator;
import org.apache.baremaps.openstreetmap.pbf.PbfReader;
import org.apache.baremaps.openstreetmap.stream.ConsumerUtils;
import org.apache.baremaps.openstreetmap.stream.StreamUtils;
import org.locationtech.jts.geom.Coordinate;

public class PbfBlockReader
implements PbfReader<Block> {
    private int buffer = Runtime.getRuntime().availableProcessors();
    private boolean geometry = false;
    private int srid = 4326;
    private Map<Long, Coordinate> coordinateMap;
    private Map<Long, List<Long>> referenceMap;

    @Override
    public int getBuffer() {
        return this.buffer;
    }

    public PbfBlockReader setBuffer(int buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public boolean getGeometries() {
        return this.geometry;
    }

    public PbfBlockReader setGeometries(boolean geometries) {
        this.geometry = geometries;
        return this;
    }

    @Override
    public int getSrid() {
        return this.srid;
    }

    public PbfBlockReader setSrid(int srid) {
        this.srid = srid;
        return this;
    }

    @Override
    public Map<Long, Coordinate> getCoordinateMap() {
        return this.coordinateMap;
    }

    public PbfBlockReader setCoordinateMap(Map<Long, Coordinate> coordinateMap) {
        this.coordinateMap = coordinateMap;
        return this;
    }

    @Override
    public Map<Long, List<Long>> getReferenceMap() {
        return this.referenceMap;
    }

    public PbfBlockReader setReferenceMap(Map<Long, List<Long>> referenceMap) {
        this.referenceMap = referenceMap;
        return this;
    }

    @Override
    public Stream<Block> read(InputStream inputStream) {
        Stream<Block> blocks = StreamUtils.bufferInSourceOrder(StreamUtils.stream(new BlobIterator(inputStream)), new BlobToBlockMapper(), Runtime.getRuntime().availableProcessors());
        if (this.geometry) {
            CoordinateMapBuilder coordinateMapBuilder = new CoordinateMapBuilder(this.coordinateMap);
            ReferenceMapBuilder referenceMapBuilder = new ReferenceMapBuilder(this.referenceMap);
            EntityGeometryBuilder entityGeometryBuilder = new EntityGeometryBuilder(this.coordinateMap, this.referenceMap);
            EntityProjectionTransformer entityProjectionTransformer = new EntityProjectionTransformer(4326, this.srid);
            Consumer<Entity> entityHandler = coordinateMapBuilder.andThen(referenceMapBuilder).andThen(entityGeometryBuilder).andThen(entityProjectionTransformer);
            UnaryOperator<Block> blockMapper = ConsumerUtils.consumeThenReturn(new BlockEntitiesHandler(entityHandler));
            blocks = blocks.map(blockMapper);
        }
        return blocks;
    }
}

