/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;

public class InteriorPointLine {
    private Coordinate centroid;
    private double minDistance = Double.MAX_VALUE;
    private Coordinate interiorPoint = null;

    public static Coordinate getInteriorPoint(Geometry geom) {
        InteriorPointLine intPt = new InteriorPointLine(geom);
        return intPt.getInteriorPoint();
    }

    public InteriorPointLine(Geometry g) {
        this.centroid = g.getCentroid().getCoordinate();
        this.addInterior(g);
        if (this.interiorPoint == null) {
            this.addEndpoints(g);
        }
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private void addInterior(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof LineString) {
            this.addInterior(geom.getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.addInterior(gc.getGeometryN(i));
            }
        }
    }

    private void addInterior(Coordinate[] pts) {
        for (int i = 1; i < pts.length - 1; ++i) {
            this.add(pts[i]);
        }
    }

    private void addEndpoints(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof LineString) {
            this.addEndpoints(geom.getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.addEndpoints(gc.getGeometryN(i));
            }
        }
    }

    private void addEndpoints(Coordinate[] pts) {
        this.add(pts[0]);
        this.add(pts[pts.length - 1]);
    }

    private void add(Coordinate point) {
        double dist = point.distance(this.centroid);
        if (dist < this.minDistance) {
            this.interiorPoint = new Coordinate(point);
            this.minDistance = dist;
        }
    }
}

