/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BooleanType;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;

public class BooleanIntegerType
extends BooleanType {
    private static final Integer TRUE_VALUE = 1;
    private static final Integer FALSE_VALUE = 0;
    private static final BooleanIntegerType singleTon = new BooleanIntegerType();

    public static BooleanIntegerType getSingleton() {
        return singleTon;
    }

    public BooleanIntegerType() {
        super(SqlType.INTEGER);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return this.javaToSqlArg(fieldType, Boolean.parseBoolean(defaultStr));
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        return (Boolean)obj != false ? TRUE_VALUE : FALSE_VALUE;
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getInt(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        return (Integer)sqlArg == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
        if (stringValue.length() == 0) {
            return Boolean.FALSE;
        }
        return this.sqlArgToJava(fieldType, Integer.parseInt(stringValue), columnPos);
    }
}

