/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.maplibre.expression;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.baremaps.maplibre.vectortile.Feature;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public interface Expressions {
    public static Expression read(String json) throws IOException {
        return (Expression)Expressions.createObjectMapper().readValue((Reader)new StringReader(json), Expression.class);
    }

    public static String write(Expression expression) throws IOException {
        return Expressions.createObjectMapper().writeValueAsString((Object)expression);
    }

    public static Predicate<Feature> asPredicate(Expression expression) {
        return row -> {
            Object result = expression.evaluate((Feature)row);
            if (result instanceof Boolean) {
                Boolean booleanResult = (Boolean)result;
                return booleanResult;
            }
            throw new IllegalArgumentException("Expression does not evaluate to a boolean: " + expression);
        };
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(Expressions.createModule());
        return mapper;
    }

    public static Module createModule() {
        SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, null));
        simpleModule.addSerializer(Expression.class, (JsonSerializer)new ExpressionSerializer());
        simpleModule.addDeserializer(Expression.class, (JsonDeserializer)new ExpressionDeserializer());
        return simpleModule;
    }

    public static interface Expression<T> {
        public String name();

        public T evaluate(Feature var1);
    }

    public static class ExpressionSerializer
    extends StdSerializer<Expression> {
        public ExpressionSerializer() {
            super(Expression.class);
        }

        public void serialize(Expression expression, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(expression.name());
            for (Field field : expression.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object value = field.get(expression);
                    if (value instanceof Expression) {
                        Expression subExpression = (Expression)value;
                        this.serialize(subExpression, jsonGenerator, serializerProvider);
                        continue;
                    }
                    jsonGenerator.writeObject(value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            jsonGenerator.writeEndArray();
        }
    }

    public static class ExpressionDeserializer
    extends StdDeserializer<Expression> {
        protected ExpressionDeserializer() {
            super(Expression.class);
        }

        public Expression deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return this.deserializeJsonNode(node);
        }

        public Expression deserializeJsonNode(JsonNode node) {
            return switch (node.getNodeType()) {
                case JsonNodeType.BOOLEAN -> new Literal(node.asBoolean());
                case JsonNodeType.NUMBER -> new Literal(node.asDouble());
                case JsonNodeType.STRING -> new Literal(node.asText());
                case JsonNodeType.ARRAY -> this.deserializeJsonArray(node);
                default -> throw new IllegalArgumentException("Unknown node type: " + node.getNodeType());
            };
        }

        public Expression deserializeJsonArray(JsonNode node) {
            ArrayList arrayList = new ArrayList();
            node.elements().forEachRemaining(arrayList::add);
            return switch (((JsonNode)arrayList.get(0)).asText()) {
                case "literal" -> new Literal(((JsonNode)arrayList.get(1)).asText());
                case "get" -> new Get(((JsonNode)arrayList.get(1)).asText());
                case "has" -> new Has(((JsonNode)arrayList.get(1)).asText());
                case ">" -> new Greater(this.deserializeJsonNode((JsonNode)arrayList.get(1)), this.deserializeJsonNode((JsonNode)arrayList.get(2)));
                case ">=" -> new GreaterOrEqual(this.deserializeJsonNode((JsonNode)arrayList.get(1)), this.deserializeJsonNode((JsonNode)arrayList.get(2)));
                case "<" -> new Less(this.deserializeJsonNode((JsonNode)arrayList.get(1)), this.deserializeJsonNode((JsonNode)arrayList.get(2)));
                case "<=" -> new LessOrEqual(this.deserializeJsonNode((JsonNode)arrayList.get(1)), this.deserializeJsonNode((JsonNode)arrayList.get(2)));
                case "==" -> new Equal(this.deserializeJsonNode((JsonNode)arrayList.get(1)), this.deserializeJsonNode((JsonNode)arrayList.get(2)));
                case "!=" -> new NotEqual(this.deserializeJsonNode((JsonNode)arrayList.get(1)), this.deserializeJsonNode((JsonNode)arrayList.get(2)));
                case "!" -> new Not(this.deserializeJsonNode((JsonNode)arrayList.get(1)));
                case "all" -> new All(arrayList.stream().skip(1L).map(this::deserializeJsonNode).toList());
                case "any" -> new Any(arrayList.stream().skip(1L).map(this::deserializeJsonNode).toList());
                case "case" -> new Case(this.deserializeJsonNode((JsonNode)arrayList.get(1)), this.deserializeJsonNode((JsonNode)arrayList.get(2)), this.deserializeJsonNode((JsonNode)arrayList.get(3)));
                case "coalesce" -> new Coalesce(arrayList.stream().skip(1L).map(this::deserializeJsonNode).toList());
                case "match" -> new Match(this.deserializeJsonNode((JsonNode)arrayList.get(1)), arrayList.subList(2, arrayList.size() - 1).stream().map(this::deserializeJsonNode).toList(), this.deserializeJsonNode((JsonNode)arrayList.get(arrayList.size() - 1)));
                case "within" -> new Within(this.deserializeJsonNode((JsonNode)arrayList.get(1)));
                default -> throw new IllegalArgumentException("Unknown expression: " + ((JsonNode)arrayList.get(0)).asText());
            };
        }
    }

    public record GeometryType(Expression expression) implements Expression<String>
    {
        @Override
        public String name() {
            return "geometry-type";
        }

        @Override
        public String evaluate(Feature feature) {
            Geometry property = feature.getGeometry();
            if (property instanceof Point) {
                return "Point";
            }
            if (property instanceof LineString) {
                return "LineString";
            }
            if (property instanceof Polygon) {
                return "Polygon";
            }
            if (property instanceof MultiPoint) {
                return "MultiPoint";
            }
            if (property instanceof MultiLineString) {
                return "MultiLineString";
            }
            if (property instanceof MultiPolygon) {
                return "MultiPolygon";
            }
            if (property instanceof GeometryCollection) {
                return "GeometryCollection";
            }
            return "Unknown";
        }
    }

    public record Within(Expression expression) implements Expression
    {
        @Override
        public String name() {
            return "within";
        }

        public Object evaluate(Feature feature) {
            throw new UnsupportedOperationException("within expression is not supported");
        }
    }

    public record Match(Expression input, List<Expression> cases, Expression fallback) implements Expression
    {
        @Override
        public String name() {
            return "match";
        }

        public Object evaluate(Feature feature) {
            if (this.cases.size() % 2 != 0) {
                throw new IllegalArgumentException("match expression must have an even number of arguments");
            }
            Object inputValue = this.input.evaluate(feature);
            for (int i = 0; i < this.cases.size(); i += 2) {
                Expression condition = this.cases.get(i);
                Expression then = this.cases.get(i + 1);
                if (!inputValue.equals(condition.evaluate(feature))) continue;
                return then.evaluate(feature);
            }
            return this.fallback.evaluate(feature);
        }
    }

    public record Coalesce(List<Expression> expressions) implements Expression
    {
        @Override
        public String name() {
            return "coalesce";
        }

        public Object evaluate(Feature feature) {
            for (Expression expression : this.expressions) {
                Object value = expression.evaluate(feature);
                if (value == null) continue;
                return value;
            }
            return null;
        }
    }

    public record Case(Expression condition, Expression then, Expression otherwise) implements Expression
    {
        @Override
        public String name() {
            return "case";
        }

        public Object evaluate(Feature feature) {
            if (((Boolean)this.condition.evaluate(feature)).booleanValue()) {
                return this.then.evaluate(feature);
            }
            return this.otherwise.evaluate(feature);
        }
    }

    public record Any(List<Expression> expressions) implements Expression
    {
        @Override
        public String name() {
            return "any";
        }

        public Object evaluate(Feature feature) {
            return this.expressions.stream().anyMatch(expression -> (Boolean)expression.evaluate(feature));
        }
    }

    public record All(List<Expression> expressions) implements Expression
    {
        @Override
        public String name() {
            return "all";
        }

        public Object evaluate(Feature feature) {
            return this.expressions.stream().allMatch(expression -> (Boolean)expression.evaluate(feature));
        }
    }

    public record GreaterOrEqual(Expression left, Expression right) implements Expression<Boolean>
    {
        @Override
        public String name() {
            return ">=";
        }

        @Override
        public Boolean evaluate(Feature feature) {
            return (Double)this.left.evaluate(feature) >= (Double)this.right.evaluate(feature);
        }
    }

    public record Greater(Expression left, Expression right) implements Expression<Boolean>
    {
        @Override
        public String name() {
            return ">";
        }

        @Override
        public Boolean evaluate(Feature feature) {
            return (Double)this.left.evaluate(feature) > (Double)this.right.evaluate(feature);
        }
    }

    public record Equal(Expression left, Expression right) implements Expression
    {
        @Override
        public String name() {
            return "==";
        }

        public Object evaluate(Feature feature) {
            return this.left.evaluate(feature).equals(this.right.evaluate(feature));
        }
    }

    public record LessOrEqual(Expression left, Expression right) implements Expression
    {
        @Override
        public String name() {
            return "<=";
        }

        public Object evaluate(Feature feature) {
            return (Double)this.left.evaluate(feature) <= (Double)this.right.evaluate(feature);
        }
    }

    public record Less(Expression left, Expression right) implements Expression<Boolean>
    {
        @Override
        public String name() {
            return "<";
        }

        @Override
        public Boolean evaluate(Feature feature) {
            return (Double)this.left.evaluate(feature) < (Double)this.right.evaluate(feature);
        }
    }

    public record NotEqual(Expression left, Expression right) implements Expression
    {
        @Override
        public String name() {
            return "!=";
        }

        public Object evaluate(Feature feature) {
            return new Not(new Equal(this.left, this.right)).evaluate(feature);
        }
    }

    public record Not(Expression expression) implements Expression
    {
        @Override
        public String name() {
            return "!";
        }

        public Object evaluate(Feature feature) {
            return (Boolean)this.expression.evaluate(feature) == false;
        }
    }

    public record Slice(Expression expression, Expression start, Expression end) implements Expression
    {
        public Slice(Expression expression, Expression start) {
            this(expression, start, null);
        }

        @Override
        public String name() {
            return "slice";
        }

        public Object evaluate(Feature feature) {
            Object value = this.expression.evaluate(feature);
            Integer startIndex = (Integer)this.start.evaluate(feature);
            if (value instanceof String) {
                String string = (String)value;
                int endIndex = this.end == null ? string.length() : ((Integer)this.end.evaluate(feature)).intValue();
                return string.substring(startIndex, endIndex);
            }
            if (value instanceof List) {
                List list = (List)value;
                int endIndex = this.end == null ? list.size() : ((Integer)this.end.evaluate(feature)).intValue();
                return list.subList(startIndex, endIndex);
            }
            return List.of();
        }
    }

    public record Length(Expression expression) implements Expression<Integer>
    {
        @Override
        public String name() {
            return "length";
        }

        @Override
        public Integer evaluate(Feature feature) {
            Object value = this.expression.evaluate(feature);
            if (value instanceof String) {
                String string = (String)value;
                return string.length();
            }
            if (value instanceof List) {
                List list = (List)value;
                return list.size();
            }
            return -1;
        }
    }

    public record IndexOf(Object value, Expression expression) implements Expression<Integer>
    {
        @Override
        public String name() {
            return "index-of";
        }

        @Override
        public Integer evaluate(Feature feature) {
            Object expressionValue = this.expression.evaluate(feature);
            if (expressionValue instanceof List) {
                List list = (List)expressionValue;
                return list.indexOf(this.value);
            }
            if (expressionValue instanceof String) {
                String string = (String)expressionValue;
                return string.indexOf(this.value.toString());
            }
            return -1;
        }
    }

    public record In(Object value, Expression expression) implements Expression<Boolean>
    {
        @Override
        public String name() {
            return "in";
        }

        @Override
        public Boolean evaluate(Feature feature) {
            Object expressionValue = this.expression.evaluate(feature);
            if (expressionValue instanceof List) {
                List list = (List)expressionValue;
                return list.contains(this.value);
            }
            if (expressionValue instanceof String) {
                String string = (String)expressionValue;
                return string.contains(this.value.toString());
            }
            return false;
        }
    }

    public record Has(String property) implements Expression<Boolean>
    {
        @Override
        public String name() {
            return "has";
        }

        @Override
        public Boolean evaluate(Feature feature) {
            return feature.getTags().get(this.property) != null;
        }
    }

    public record Get(String property) implements Expression
    {
        @Override
        public String name() {
            return "get";
        }

        public Object evaluate(Feature feature) {
            return feature.getTags().get(this.property);
        }
    }

    public record At(int index, Expression expression) implements Expression
    {
        @Override
        public String name() {
            return "at";
        }

        public Object evaluate(Feature feature) {
            Object value = this.expression.evaluate(feature);
            if (value instanceof List) {
                List list = (List)value;
                if (this.index >= 0 && this.index < list.size()) {
                    return list.get(this.index);
                }
            }
            return null;
        }
    }

    public record Literal(Object value) implements Expression
    {
        @Override
        public String name() {
            return "literal";
        }

        public Object evaluate(Feature feature) {
            return this.value;
        }
    }
}

