/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageBuilder;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.datum.PixelInCell;

public final class MemoryGridResource
extends AbstractGridCoverageResource {
    public final GridCoverage coverage;
    private final GridCoverageProcessor processor;

    public MemoryGridResource(StoreListeners parent, GridCoverage coverage, GridCoverageProcessor processor) {
        super(parent, false);
        ArgumentChecks.ensureNonNull((String)"coverage", (Object)coverage);
        this.coverage = coverage;
        this.processor = processor != null ? processor : new GridCoverageProcessor();
    }

    @Override
    public GridGeometry getGridGeometry() {
        return this.coverage.getGridGeometry();
    }

    @Override
    public List<SampleDimension> getSampleDimensions() {
        return this.coverage.getSampleDimensions();
    }

    @Override
    public GridCoverage read(GridGeometry domain, int ... ranges) {
        GridCoverage subset = this.coverage;
        if (ranges != null && ranges.length != 0) {
            subset = this.processor.selectSampleDimensions(subset, ranges);
        }
        GridExtent intersection = null;
        GridGeometry source = subset.getGridGeometry();
        if (domain == null) {
            domain = source;
        } else {
            intersection = source.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(domain).getIntersection();
            if (intersection.equals((Object)source.getExtent())) {
                intersection = null;
                domain = source;
            }
        }
        if (intersection == null) {
            return subset;
        }
        RenderedImage data = subset.render(intersection);
        if (intersection != null) {
            int[] sd = intersection.getSubspaceDimensions(2);
            int dimX = sd[0];
            int dimY = sd[1];
            long ox = intersection.getLow(dimX);
            long oy = intersection.getLow(dimY);
            long[] changes = new long[Math.max(dimX, dimY) + 1];
            int i = changes.length;
            while (--i >= 0) {
                changes[i] = intersection.getSize(i);
            }
            changes[dimX] = data.getWidth();
            changes[dimY] = data.getHeight();
            intersection = intersection.resize(changes);
            Arrays.fill(changes, 0L);
            changes[dimX] = Math.addExact(ox - intersection.getLow(dimX), (long)data.getMinX());
            changes[dimY] = Math.addExact(oy - intersection.getLow(dimY), (long)data.getMinX());
            intersection = intersection.translate(changes);
            if (intersection.equals((Object)source.getExtent())) {
                return subset;
            }
            domain = new GridGeometry(intersection, PixelInCell.CELL_CORNER, source.getGridToCRS(PixelInCell.CELL_CORNER), source.getCoordinateReferenceSystem());
        }
        return new GridCoverageBuilder().setValues(data).setDomain(domain).setRanges((Collection)subset.getSampleDimensions()).build();
    }
}

