/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.image;

import java.util.function.Predicate;
import javax.imageio.ImageIO;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;

public final class DataStoreFilter
implements Predicate<DataStoreProvider> {
    final String preferred;
    private final boolean writer;
    private final Predicate<? super DataStoreProvider> other;

    public DataStoreFilter(String preferred, boolean writer) {
        this.preferred = preferred;
        this.writer = writer;
        this.other = null;
    }

    private DataStoreFilter(DataStoreFilter first, Predicate<? super DataStoreProvider> other) {
        this.preferred = first.preferred;
        this.writer = first.writer;
        this.other = other;
    }

    @Override
    public boolean test(DataStoreProvider candidate) {
        String formatName = StoreUtilities.getFormatName(candidate);
        if (CharSequences.equalsFiltered((CharSequence)formatName, (CharSequence)this.preferred, (Characters.Filter)Characters.Filter.UNICODE_IDENTIFIER, (boolean)true)) {
            return true;
        }
        if ("World file".equals(formatName)) {
            String[] formats = this.writer ? ImageIO.getWriterFormatNames() : ImageIO.getReaderFormatNames();
            return ArraysExt.containsIgnoreCase((String[])formats, (String)this.preferred);
        }
        return false;
    }

    @Override
    public Predicate<DataStoreProvider> and(Predicate<? super DataStoreProvider> other) {
        return new DataStoreFilter(this, other);
    }
}

