/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoder.geonames;

import java.util.function.Function;
import org.apache.baremaps.geocoder.geonames.GeonamesEntry;
import org.apache.baremaps.utils.IsoCountriesUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class GeonamesDocumentMapper
implements Function<GeonamesEntry, Document> {
    @Override
    public Document apply(GeonamesEntry entry) {
        Document document = new Document();
        document.add((IndexableField)new TextField("name", entry.getName(), Field.Store.YES));
        document.add((IndexableField)new TextField("country", IsoCountriesUtils.getCountry(entry.getCountryCode()), Field.Store.YES));
        document.add((IndexableField)new StringField("countryCode", entry.getCountryCode(), Field.Store.YES));
        document.add((IndexableField)new LatLonPoint("point", entry.getLatitude().doubleValue(), entry.getLongitude().doubleValue()));
        document.add((IndexableField)new StoredField("longitude", entry.getLongitude().doubleValue()));
        document.add((IndexableField)new StoredField("latitude", entry.getLatitude().doubleValue()));
        document.add((IndexableField)new TextField("asciiname", entry.getAsciiname(), Field.Store.YES));
        document.add((IndexableField)new StoredField("alternatenames", entry.getAlternatenames()));
        document.add((IndexableField)new StringField("featureClass", entry.getFeatureClass(), Field.Store.YES));
        document.add((IndexableField)new StringField("featureCode", entry.getFeatureCode(), Field.Store.YES));
        document.add((IndexableField)new StoredField("cc2", entry.getCc2()));
        document.add((IndexableField)new StoredField("admin1Code", entry.getAdmin1Code()));
        document.add((IndexableField)new StoredField("admin2Code", entry.getAdmin2Code()));
        document.add((IndexableField)new StoredField("admin3Code", entry.getAdmin3Code()));
        document.add((IndexableField)new StoredField("admin4Code", entry.getAdmin4Code()));
        document.add((IndexableField)new NumericDocValuesField("population", entry.getPopulation()));
        document.add((IndexableField)new StoredField("population", entry.getPopulation().longValue()));
        if (entry.getElevation() != null) {
            document.add((IndexableField)new StoredField("elevation", entry.getElevation().intValue()));
        }
        document.add((IndexableField)new StoredField("dem", entry.getDem().intValue()));
        document.add((IndexableField)new StoredField("timezone", entry.getTimezone()));
        document.add((IndexableField)new StoredField("modificationDate", entry.getModificationDate()));
        return document;
    }
}

